/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_1.dsl.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.clnt.v4_1.Config;
import io.fabric8.kubernetes.clnt.v4_1.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_1.VersionInfo;
import io.fabric8.kubernetes.clnt.v4_1.dsl.base.OperationSupport;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class ClusterOperationsImpl
extends OperationSupport {
    private String versionEndpoint;

    public ClusterOperationsImpl(OkHttpClient client, Config config, String item) {
        super(client, config, null, null, null, null, null);
        this.versionEndpoint = item;
    }

    public VersionInfo fetchVersion() {
        try {
            Request.Builder requestBuilder = new Request.Builder().get().url(this.config.getMasterUrl() + this.versionEndpoint);
            Response response = this.client.newCall(requestBuilder.build()).execute();
            ObjectMapper objectMapper = new ObjectMapper();
            Map myMap = (Map)objectMapper.readValue(response.body().string(), HashMap.class);
            return new VersionInfo(myMap);
        }
        catch (Exception e) {
            KubernetesClientException.launderThrowable(e);
            return null;
        }
    }
}

