/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1.rbac;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.rbac.KubernetesRoleRef;
import io.fabric8.kubernetes.api.model.v4_1.rbac.KubernetesRoleRefFluent;
import io.fabric8.kubernetes.api.model.v4_1.rbac.KubernetesRoleRefFluentImpl;
import javax.validation.Validator;

public class KubernetesRoleRefBuilder
extends KubernetesRoleRefFluentImpl<KubernetesRoleRefBuilder>
implements VisitableBuilder<KubernetesRoleRef, KubernetesRoleRefBuilder> {
    KubernetesRoleRefFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public KubernetesRoleRefBuilder() {
        this(true);
    }

    public KubernetesRoleRefBuilder(Boolean validationEnabled) {
        this(new KubernetesRoleRef(), validationEnabled);
    }

    public KubernetesRoleRefBuilder(KubernetesRoleRefFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KubernetesRoleRefBuilder(KubernetesRoleRefFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesRoleRef(), validationEnabled);
    }

    public KubernetesRoleRefBuilder(KubernetesRoleRefFluent<?> fluent, KubernetesRoleRef instance) {
        this(fluent, instance, true);
    }

    public KubernetesRoleRefBuilder(KubernetesRoleRefFluent<?> fluent, KubernetesRoleRef instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroup(instance.getApiGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesRoleRefBuilder(KubernetesRoleRef instance) {
        this(instance, (Boolean)true);
    }

    public KubernetesRoleRefBuilder(KubernetesRoleRef instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroup(instance.getApiGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesRoleRefBuilder(Validator validator) {
        this(new KubernetesRoleRef(), (Boolean)true);
    }

    public KubernetesRoleRefBuilder(KubernetesRoleRefFluent<?> fluent, KubernetesRoleRef instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiGroup(instance.getApiGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public KubernetesRoleRefBuilder(KubernetesRoleRef instance, Validator validator) {
        this.fluent = this;
        this.withApiGroup(instance.getApiGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public KubernetesRoleRef build() {
        KubernetesRoleRef buildable = new KubernetesRoleRef(this.fluent.getApiGroup(), this.fluent.getKind(), this.fluent.getName());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesRoleRefBuilder that = (KubernetesRoleRefBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

