/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1.rbac;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.rbac.KubernetesClusterRole;
import io.fabric8.kubernetes.api.model.v4_1.rbac.KubernetesClusterRoleFluent;
import io.fabric8.kubernetes.api.model.v4_1.rbac.KubernetesClusterRoleFluentImpl;
import javax.validation.Validator;

public class KubernetesClusterRoleBuilder
extends KubernetesClusterRoleFluentImpl<KubernetesClusterRoleBuilder>
implements VisitableBuilder<KubernetesClusterRole, KubernetesClusterRoleBuilder> {
    KubernetesClusterRoleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public KubernetesClusterRoleBuilder() {
        this(true);
    }

    public KubernetesClusterRoleBuilder(Boolean validationEnabled) {
        this(new KubernetesClusterRole(), validationEnabled);
    }

    public KubernetesClusterRoleBuilder(KubernetesClusterRoleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KubernetesClusterRoleBuilder(KubernetesClusterRoleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesClusterRole(), validationEnabled);
    }

    public KubernetesClusterRoleBuilder(KubernetesClusterRoleFluent<?> fluent, KubernetesClusterRole instance) {
        this(fluent, instance, true);
    }

    public KubernetesClusterRoleBuilder(KubernetesClusterRoleFluent<?> fluent, KubernetesClusterRole instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAggregationRule(instance.getAggregationRule());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesClusterRoleBuilder(KubernetesClusterRole instance) {
        this(instance, (Boolean)true);
    }

    public KubernetesClusterRoleBuilder(KubernetesClusterRole instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAggregationRule(instance.getAggregationRule());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesClusterRoleBuilder(Validator validator) {
        this(new KubernetesClusterRole(), (Boolean)true);
    }

    public KubernetesClusterRoleBuilder(KubernetesClusterRoleFluent<?> fluent, KubernetesClusterRole instance, Validator validator) {
        this.fluent = fluent;
        fluent.withAggregationRule(instance.getAggregationRule());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRules(instance.getRules());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public KubernetesClusterRoleBuilder(KubernetesClusterRole instance, Validator validator) {
        this.fluent = this;
        this.withAggregationRule(instance.getAggregationRule());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public KubernetesClusterRole build() {
        KubernetesClusterRole buildable = new KubernetesClusterRole(this.fluent.getAggregationRule(), this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRules());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesClusterRoleBuilder that = (KubernetesClusterRoleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

