/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1.rbac;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.rbac.KubernetesAggregationRule;
import io.fabric8.kubernetes.api.model.v4_1.rbac.KubernetesAggregationRuleFluent;
import io.fabric8.kubernetes.api.model.v4_1.rbac.KubernetesAggregationRuleFluentImpl;
import javax.validation.Validator;

public class KubernetesAggregationRuleBuilder
extends KubernetesAggregationRuleFluentImpl<KubernetesAggregationRuleBuilder>
implements VisitableBuilder<KubernetesAggregationRule, KubernetesAggregationRuleBuilder> {
    KubernetesAggregationRuleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public KubernetesAggregationRuleBuilder() {
        this(true);
    }

    public KubernetesAggregationRuleBuilder(Boolean validationEnabled) {
        this(new KubernetesAggregationRule(), validationEnabled);
    }

    public KubernetesAggregationRuleBuilder(KubernetesAggregationRuleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KubernetesAggregationRuleBuilder(KubernetesAggregationRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesAggregationRule(), validationEnabled);
    }

    public KubernetesAggregationRuleBuilder(KubernetesAggregationRuleFluent<?> fluent, KubernetesAggregationRule instance) {
        this(fluent, instance, true);
    }

    public KubernetesAggregationRuleBuilder(KubernetesAggregationRuleFluent<?> fluent, KubernetesAggregationRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withClusterRoleSelectors(instance.getClusterRoleSelectors());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesAggregationRuleBuilder(KubernetesAggregationRule instance) {
        this(instance, (Boolean)true);
    }

    public KubernetesAggregationRuleBuilder(KubernetesAggregationRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withClusterRoleSelectors(instance.getClusterRoleSelectors());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesAggregationRuleBuilder(Validator validator) {
        this(new KubernetesAggregationRule(), (Boolean)true);
    }

    public KubernetesAggregationRuleBuilder(KubernetesAggregationRuleFluent<?> fluent, KubernetesAggregationRule instance, Validator validator) {
        this.fluent = fluent;
        fluent.withClusterRoleSelectors(instance.getClusterRoleSelectors());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public KubernetesAggregationRuleBuilder(KubernetesAggregationRule instance, Validator validator) {
        this.fluent = this;
        this.withClusterRoleSelectors(instance.getClusterRoleSelectors());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public KubernetesAggregationRule build() {
        KubernetesAggregationRule buildable = new KubernetesAggregationRule(this.fluent.getClusterRoleSelectors());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesAggregationRuleBuilder that = (KubernetesAggregationRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

