/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1.extensions;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.extensions.IngressList;
import io.fabric8.kubernetes.api.model.v4_1.extensions.IngressListFluent;
import io.fabric8.kubernetes.api.model.v4_1.extensions.IngressListFluentImpl;
import javax.validation.Validator;

public class IngressListBuilder
extends IngressListFluentImpl<IngressListBuilder>
implements VisitableBuilder<IngressList, IngressListBuilder> {
    IngressListFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public IngressListBuilder() {
        this(true);
    }

    public IngressListBuilder(Boolean validationEnabled) {
        this(new IngressList(), validationEnabled);
    }

    public IngressListBuilder(IngressListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public IngressListBuilder(IngressListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new IngressList(), validationEnabled);
    }

    public IngressListBuilder(IngressListFluent<?> fluent, IngressList instance) {
        this(fluent, instance, true);
    }

    public IngressListBuilder(IngressListFluent<?> fluent, IngressList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public IngressListBuilder(IngressList instance) {
        this(instance, (Boolean)true);
    }

    public IngressListBuilder(IngressList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public IngressListBuilder(Validator validator) {
        this(new IngressList(), (Boolean)true);
    }

    public IngressListBuilder(IngressListFluent<?> fluent, IngressList instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public IngressListBuilder(IngressList instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public IngressList build() {
        IngressList buildable = new IngressList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IngressListBuilder that = (IngressListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

