/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.NodeConfigSource;
import io.fabric8.kubernetes.api.model.v4_1.NodeConfigSourceFluent;
import io.fabric8.kubernetes.api.model.v4_1.NodeConfigSourceFluentImpl;
import javax.validation.Validator;

public class NodeConfigSourceBuilder
extends NodeConfigSourceFluentImpl<NodeConfigSourceBuilder>
implements VisitableBuilder<NodeConfigSource, NodeConfigSourceBuilder> {
    NodeConfigSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NodeConfigSourceBuilder() {
        this(true);
    }

    public NodeConfigSourceBuilder(Boolean validationEnabled) {
        this(new NodeConfigSource(), validationEnabled);
    }

    public NodeConfigSourceBuilder(NodeConfigSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeConfigSourceBuilder(NodeConfigSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeConfigSource(), validationEnabled);
    }

    public NodeConfigSourceBuilder(NodeConfigSourceFluent<?> fluent, NodeConfigSource instance) {
        this(fluent, instance, true);
    }

    public NodeConfigSourceBuilder(NodeConfigSourceFluent<?> fluent, NodeConfigSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withConfigMapRef(instance.getConfigMapRef());
        fluent.withKind(instance.getKind());
        this.validationEnabled = validationEnabled;
    }

    public NodeConfigSourceBuilder(NodeConfigSource instance) {
        this(instance, (Boolean)true);
    }

    public NodeConfigSourceBuilder(NodeConfigSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withConfigMapRef(instance.getConfigMapRef());
        this.withKind(instance.getKind());
        this.validationEnabled = validationEnabled;
    }

    public NodeConfigSourceBuilder(Validator validator) {
        this(new NodeConfigSource(), (Boolean)true);
    }

    public NodeConfigSourceBuilder(NodeConfigSourceFluent<?> fluent, NodeConfigSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withConfigMapRef(instance.getConfigMapRef());
        fluent.withKind(instance.getKind());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NodeConfigSourceBuilder(NodeConfigSource instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withConfigMapRef(instance.getConfigMapRef());
        this.withKind(instance.getKind());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NodeConfigSource build() {
        NodeConfigSource buildable = new NodeConfigSource(this.fluent.getApiVersion(), this.fluent.getConfigMapRef(), this.fluent.getKind());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeConfigSourceBuilder that = (NodeConfigSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

