/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.NodeAffinity;
import io.fabric8.kubernetes.api.model.v4_1.NodeAffinityFluent;
import io.fabric8.kubernetes.api.model.v4_1.NodeAffinityFluentImpl;
import javax.validation.Validator;

public class NodeAffinityBuilder
extends NodeAffinityFluentImpl<NodeAffinityBuilder>
implements VisitableBuilder<NodeAffinity, NodeAffinityBuilder> {
    NodeAffinityFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public NodeAffinityBuilder() {
        this(true);
    }

    public NodeAffinityBuilder(Boolean validationEnabled) {
        this(new NodeAffinity(), validationEnabled);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeAffinity(), validationEnabled);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent, NodeAffinity instance) {
        this(fluent, instance, true);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent, NodeAffinity instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
        fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
        this.validationEnabled = validationEnabled;
    }

    public NodeAffinityBuilder(NodeAffinity instance) {
        this(instance, (Boolean)true);
    }

    public NodeAffinityBuilder(NodeAffinity instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
        this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
        this.validationEnabled = validationEnabled;
    }

    public NodeAffinityBuilder(Validator validator) {
        this(new NodeAffinity(), (Boolean)true);
    }

    public NodeAffinityBuilder(NodeAffinityFluent<?> fluent, NodeAffinity instance, Validator validator) {
        this.fluent = fluent;
        fluent.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
        fluent.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public NodeAffinityBuilder(NodeAffinity instance, Validator validator) {
        this.fluent = this;
        this.withPreferredDuringSchedulingIgnoredDuringExecution(instance.getPreferredDuringSchedulingIgnoredDuringExecution());
        this.withRequiredDuringSchedulingIgnoredDuringExecution(instance.getRequiredDuringSchedulingIgnoredDuringExecution());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public NodeAffinity build() {
        NodeAffinity buildable = new NodeAffinity(this.fluent.getPreferredDuringSchedulingIgnoredDuringExecution(), this.fluent.getRequiredDuringSchedulingIgnoredDuringExecution());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeAffinityBuilder that = (NodeAffinityBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

