/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_1;

import io.fabric8.kubernetes.api.builder.v4_1.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_1.LimitRange;
import io.fabric8.kubernetes.api.model.v4_1.LimitRangeFluent;
import io.fabric8.kubernetes.api.model.v4_1.LimitRangeFluentImpl;
import javax.validation.Validator;

public class LimitRangeBuilder
extends LimitRangeFluentImpl<LimitRangeBuilder>
implements VisitableBuilder<LimitRange, LimitRangeBuilder> {
    LimitRangeFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public LimitRangeBuilder() {
        this(true);
    }

    public LimitRangeBuilder(Boolean validationEnabled) {
        this(new LimitRange(), validationEnabled);
    }

    public LimitRangeBuilder(LimitRangeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public LimitRangeBuilder(LimitRangeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LimitRange(), validationEnabled);
    }

    public LimitRangeBuilder(LimitRangeFluent<?> fluent, LimitRange instance) {
        this(fluent, instance, true);
    }

    public LimitRangeBuilder(LimitRangeFluent<?> fluent, LimitRange instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public LimitRangeBuilder(LimitRange instance) {
        this(instance, (Boolean)true);
    }

    public LimitRangeBuilder(LimitRange instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public LimitRangeBuilder(Validator validator) {
        this(new LimitRange(), (Boolean)true);
    }

    public LimitRangeBuilder(LimitRangeFluent<?> fluent, LimitRange instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public LimitRangeBuilder(LimitRange instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public LimitRange build() {
        LimitRange buildable = new LimitRange(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LimitRangeBuilder that = (LimitRangeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

