/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v4_0.dsl.internal;

import io.fabric8.kubernetes.clnt.v4_0.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v4_0.dsl.Reaper;
import io.fabric8.kubernetes.clnt.v4_0.dsl.internal.ReplicationControllerOperationsImpl;
import io.fabric8.kubernetes.clnt.v4_0.utils.Utils;
import io.fabric8.openshift.api.model.v4_0.DeploymentConfig;
import io.fabric8.openshift.api.model.v4_0.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.v4_0.DeploymentConfigList;
import io.fabric8.openshift.api.model.v4_0.DoneableDeploymentConfig;
import io.fabric8.openshift.clnt.v4_0.OpenShiftConfig;
import io.fabric8.openshift.clnt.v4_0.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v4_0.dsl.internal.OpenShiftOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentConfigOperationsImpl
extends OpenShiftOperation<DeploymentConfig, DeploymentConfigList, DoneableDeploymentConfig, DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig>>
implements DeployableScalableResource<DeploymentConfig, DoneableDeploymentConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentConfigOperationsImpl.class);
    private static final String DEPLOYMENT_CONFIG_REF = "openshift.io/deployment-config.name";

    public DeploymentConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config, String namespace) {
        this(client, config, null, namespace, null, (Boolean)true, null, null, (Boolean)false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>());
    }

    public DeploymentConfigOperationsImpl(OkHttpClient client, OpenShiftConfig config, String apiVersion, String namespace, String name, Boolean cascading, DeploymentConfig item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        super(client, OpenShiftOperation.withApiGroup(client, "apps.openshift.io", apiVersion, config), "deploymentconfigs", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields);
        this.reaper = new DeploymentConfigReaper(this, client);
    }

    @Override
    public DoneableDeploymentConfig edit() {
        if (this.isCascading().booleanValue()) {
            return (DoneableDeploymentConfig)this.cascading(false).edit();
        }
        return (DoneableDeploymentConfig)super.edit();
    }

    @Override
    public DeploymentConfig replace(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return (DeploymentConfig)this.cascading(false).replace(item);
        }
        return super.replace(item);
    }

    @Override
    public DeploymentConfig patch(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return (DeploymentConfig)this.cascading(false).patch(item);
        }
        return super.patch(item);
    }

    @Override
    public DeploymentConfig deployLatest() {
        return this.deployLatest(false);
    }

    @Override
    public DeploymentConfig deployLatest(boolean wait) {
        Long currentVersion = ((DeploymentConfig)this.getMandatory()).getStatus().getLatestVersion();
        if (currentVersion == null) {
            currentVersion = 1L;
        }
        currentVersion = currentVersion + 1L;
        DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.StatusNested)((DoneableDeploymentConfig)this.cascading(false).edit()).editStatus().withLatestVersion(currentVersion)).endStatus()).done();
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(deployment.getSpec().getReplicas());
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    @Override
    public DeploymentConfig scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public DeploymentConfig scale(int count, boolean wait) {
        DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(count);
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDeploymentConfigIsScaled(final int count) {
        final ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        final AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        final String namespace = this.checkNamespace(this.getItem());
        Runnable deploymentPoller = new Runnable(){

            @Override
            public void run() {
                try {
                    int currentReplicas;
                    DeploymentConfig deploymentConfig = (DeploymentConfig)DeploymentConfigOperationsImpl.this.get();
                    if (deploymentConfig == null) {
                        if (count == 0) {
                            queue.put(true);
                            return;
                        }
                        queue.put(new IllegalStateException("Can't wait for DeploymentConfig: " + DeploymentConfigOperationsImpl.this.checkName(DeploymentConfigOperationsImpl.this.getItem()) + " in namespace: " + DeploymentConfigOperationsImpl.this.checkName(DeploymentConfigOperationsImpl.this.getItem()) + " to scale. Resource is no longer available."));
                        return;
                    }
                    replicasRef.set(deploymentConfig.getStatus().getReplicas());
                    int n = currentReplicas = deploymentConfig.getStatus().getReplicas() != null ? deploymentConfig.getStatus().getReplicas() : 0;
                    if (deploymentConfig.getStatus().getObservedGeneration() >= deploymentConfig.getMetadata().getGeneration() && Objects.equals(deploymentConfig.getSpec().getReplicas(), currentReplicas)) {
                        queue.put(true);
                    } else {
                        LOG.debug("Only {}/{} pods scheduled for DeploymentConfig: {} in namespace: {} seconds so waiting...", new Object[]{deploymentConfig.getStatus().getReplicas(), deploymentConfig.getSpec().getReplicas(), deploymentConfig.getMetadata().getName(), namespace});
                    }
                }
                catch (Throwable t) {
                    LOG.error("Error while waiting for Deployment to be scaled.", t);
                }
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS)) {
                LOG.debug("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
            } else {
                LOG.error("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    private static class DeploymentConfigReaper
    implements Reaper {
        private final DeploymentConfigOperationsImpl operation;
        private final OkHttpClient client;

        public DeploymentConfigReaper(DeploymentConfigOperationsImpl operation, OkHttpClient client) {
            this.operation = operation;
            this.client = client;
        }

        @Override
        public boolean reap() {
            DeploymentConfig deployment = ((DoneableDeploymentConfig)((DeploymentConfigFluent.SpecNested)((DoneableDeploymentConfig)this.operation.cascading(false).edit()).editSpec().withReplicas(0)).endSpec()).done();
            if (deployment.getStatus() != null) {
                this.waitForObservedGeneration(deployment.getStatus().getObservedGeneration());
            }
            Boolean reaped = (Boolean)this.operation.cascading(false).delete();
            this.waitForDeletion();
            HashMap<String, String> selector = new HashMap<String, String>();
            selector.put(DeploymentConfigOperationsImpl.DEPLOYMENT_CONFIG_REF, deployment.getMetadata().getName());
            if (selector != null && !selector.isEmpty()) {
                Boolean bl = (Boolean)new ReplicationControllerOperationsImpl(this.client, this.operation.getConfig(), this.operation.getNamespace()).withLabels(selector).delete();
            }
            return reaped;
        }

        private void waitForObservedGeneration(final long observedGeneration) {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable deploymentPoller = new Runnable(){

                @Override
                public void run() {
                    DeploymentConfig deployment = (DeploymentConfig)operation.getMandatory();
                    if (observedGeneration <= deployment.getStatus().getObservedGeneration()) {
                        countDownLatch.countDown();
                    }
                }
            };
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 10L, TimeUnit.MILLISECONDS);
            try {
                countDownLatch.await(1L, TimeUnit.MINUTES);
                executor.shutdown();
            }
            catch (InterruptedException e) {
                poller.cancel(true);
                executor.shutdown();
                throw KubernetesClientException.launderThrowable(e);
            }
        }

        private void waitForDeletion() {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            Runnable deploymentPoller = new Runnable(){

                @Override
                public void run() {
                    DeploymentConfig deployment = (DeploymentConfig)operation.get();
                    if (deployment == null) {
                        countDownLatch.countDown();
                    }
                }
            };
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 10L, TimeUnit.MILLISECONDS);
            try {
                countDownLatch.await(1L, TimeUnit.MINUTES);
                executor.shutdown();
            }
            catch (InterruptedException e) {
                poller.cancel(true);
                executor.shutdown();
                throw KubernetesClientException.launderThrowable(e);
            }
        }
    }
}

