/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import io.fabric8.kubernetes.api.model.v4_0.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_0.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_0.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v4_0.ObjectReference;
import io.fabric8.kubernetes.api.model.v4_0.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v4_0.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v4_0.RoleBinding;
import io.fabric8.openshift.api.model.v4_0.RoleBindingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RoleBindingFluentImpl<A extends RoleBindingFluent<A>>
extends BaseFluent<A>
implements RoleBindingFluent<A> {
    private String apiVersion;
    private List<String> groupNames = new ArrayList<String>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private ObjectReferenceBuilder roleRef;
    private List<ObjectReferenceBuilder> subjects = new ArrayList<ObjectReferenceBuilder>();
    private List<String> userNames = new ArrayList<String>();

    public RoleBindingFluentImpl() {
    }

    public RoleBindingFluentImpl(RoleBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGroupNames(instance.getGroupNames());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.withUserNames(instance.getUserNames());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToGroupNames(int index, String item) {
        this.groupNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroupNames(int index, String item) {
        this.groupNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroupNames(String ... items) {
        for (String item : items) {
            this.groupNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroupNames(Collection<String> items) {
        for (String item : items) {
            this.groupNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroupNames(String ... items) {
        for (String item : items) {
            this.groupNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroupNames(Collection<String> items) {
        for (String item : items) {
            this.groupNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroupNames() {
        return this.groupNames;
    }

    @Override
    public String getGroupName(int index) {
        return this.groupNames.get(index);
    }

    @Override
    public String getFirstGroupName() {
        return this.groupNames.get(0);
    }

    @Override
    public String getLastGroupName() {
        return this.groupNames.get(this.groupNames.size() - 1);
    }

    @Override
    public String getMatchingGroupName(Predicate<String> predicate) {
        for (String item : this.groupNames) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withGroupNames(List<String> groupNames) {
        this.groupNames.clear();
        if (groupNames != null) {
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withGroupNames(String ... groupNames) {
        this.groupNames.clear();
        if (groupNames != null) {
            for (String item : groupNames) {
                this.addToGroupNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroupNames() {
        return this.groupNames != null && !this.groupNames.isEmpty();
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ObjectReference getRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public ObjectReference buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public A withRoleRef(ObjectReference roleRef) {
        this._visitables.remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new ObjectReferenceBuilder(roleRef);
            this._visitables.add(this.roleRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleRef() {
        return this.roleRef != null;
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(ObjectReference item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(ObjectReference item) {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : item);
    }

    @Override
    public A addToSubjects(int index, ObjectReference item) {
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.subjects.add(index >= 0 ? index : this.subjects.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubjects(int index, ObjectReference item) {
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.subjects.size()) {
            this.subjects.add(builder);
        } else {
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubjects(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(ObjectReference ... items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<ObjectReference> items) {
        for (ObjectReference item : items) {
            ObjectReferenceBuilder builder = new ObjectReferenceBuilder(item);
            this._visitables.remove(builder);
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ObjectReference> getSubjects() {
        return RoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public List<ObjectReference> buildSubjects() {
        return RoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public ObjectReference buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    @Override
    public ObjectReference buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    @Override
    public ObjectReference buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    @Override
    public ObjectReference buildMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
        for (ObjectReferenceBuilder item : this.subjects) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withSubjects(List<ObjectReference> subjects) {
        this._visitables.removeAll(this.subjects);
        this.subjects.clear();
        if (subjects != null) {
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withSubjects(ObjectReference ... subjects) {
        this.subjects.clear();
        if (subjects != null) {
            for (ObjectReference item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(ObjectReference item) {
        return new SubjectsNestedImpl(-1, item);
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index, ObjectReference item) {
        return new SubjectsNestedImpl(index, item);
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<ObjectReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.apply(this.subjects.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public A addToUserNames(int index, String item) {
        this.userNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToUserNames(int index, String item) {
        this.userNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToUserNames(String ... items) {
        for (String item : items) {
            this.userNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToUserNames(Collection<String> items) {
        for (String item : items) {
            this.userNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromUserNames(String ... items) {
        for (String item : items) {
            this.userNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromUserNames(Collection<String> items) {
        for (String item : items) {
            this.userNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getUserNames() {
        return this.userNames;
    }

    @Override
    public String getUserName(int index) {
        return this.userNames.get(index);
    }

    @Override
    public String getFirstUserName() {
        return this.userNames.get(0);
    }

    @Override
    public String getLastUserName() {
        return this.userNames.get(this.userNames.size() - 1);
    }

    @Override
    public String getMatchingUserName(Predicate<String> predicate) {
        for (String item : this.userNames) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withUserNames(List<String> userNames) {
        this.userNames.clear();
        if (userNames != null) {
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withUserNames(String ... userNames) {
        this.userNames.clear();
        if (userNames != null) {
            for (String item : userNames) {
                this.addToUserNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasUserNames() {
        return this.userNames != null && !this.userNames.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleBindingFluentImpl that = (RoleBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groupNames != null ? !this.groupNames.equals(that.groupNames) : that.groupNames != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals(that.roleRef) : that.roleRef != null) {
            return false;
        }
        if (this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null) {
            return false;
        }
        return !(this.userNames != null ? !this.userNames.equals(that.userNames) : that.userNames != null);
    }

    public class SubjectsNestedImpl<N>
    extends ObjectReferenceFluentImpl<RoleBindingFluent.SubjectsNested<N>>
    implements RoleBindingFluent.SubjectsNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;
        private final int index;

        SubjectsNestedImpl(int index, ObjectReference item) {
            this.index = index;
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        SubjectsNestedImpl() {
            this.index = -1;
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.setToSubjects(this.index, this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<RoleBindingFluent.RoleRefNested<N>>
    implements RoleBindingFluent.RoleRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        RoleRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        RoleRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<RoleBindingFluent.MetadataNested<N>>
    implements RoleBindingFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

