/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import io.fabric8.openshift.api.model.v4_0.ExecNewPodHook;
import io.fabric8.openshift.api.model.v4_0.ExecNewPodHookBuilder;
import io.fabric8.openshift.api.model.v4_0.ExecNewPodHookFluentImpl;
import io.fabric8.openshift.api.model.v4_0.LifecycleHook;
import io.fabric8.openshift.api.model.v4_0.LifecycleHookFluent;
import io.fabric8.openshift.api.model.v4_0.TagImageHook;
import io.fabric8.openshift.api.model.v4_0.TagImageHookBuilder;
import io.fabric8.openshift.api.model.v4_0.TagImageHookFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LifecycleHookFluentImpl<A extends LifecycleHookFluent<A>>
extends BaseFluent<A>
implements LifecycleHookFluent<A> {
    private ExecNewPodHookBuilder execNewPod;
    private String failurePolicy;
    private List<TagImageHookBuilder> tagImages = new ArrayList<TagImageHookBuilder>();

    public LifecycleHookFluentImpl() {
    }

    public LifecycleHookFluentImpl(LifecycleHook instance) {
        this.withExecNewPod(instance.getExecNewPod());
        this.withFailurePolicy(instance.getFailurePolicy());
        this.withTagImages(instance.getTagImages());
    }

    @Override
    @Deprecated
    public ExecNewPodHook getExecNewPod() {
        return this.execNewPod != null ? this.execNewPod.build() : null;
    }

    @Override
    public ExecNewPodHook buildExecNewPod() {
        return this.execNewPod != null ? this.execNewPod.build() : null;
    }

    @Override
    public A withExecNewPod(ExecNewPodHook execNewPod) {
        this._visitables.remove(this.execNewPod);
        if (execNewPod != null) {
            this.execNewPod = new ExecNewPodHookBuilder(execNewPod);
            this._visitables.add(this.execNewPod);
        }
        return (A)this;
    }

    @Override
    public Boolean hasExecNewPod() {
        return this.execNewPod != null;
    }

    @Override
    public LifecycleHookFluent.ExecNewPodNested<A> withNewExecNewPod() {
        return new ExecNewPodNestedImpl();
    }

    @Override
    public LifecycleHookFluent.ExecNewPodNested<A> withNewExecNewPodLike(ExecNewPodHook item) {
        return new ExecNewPodNestedImpl(item);
    }

    @Override
    public LifecycleHookFluent.ExecNewPodNested<A> editExecNewPod() {
        return this.withNewExecNewPodLike(this.getExecNewPod());
    }

    @Override
    public LifecycleHookFluent.ExecNewPodNested<A> editOrNewExecNewPod() {
        return this.withNewExecNewPodLike(this.getExecNewPod() != null ? this.getExecNewPod() : new ExecNewPodHookBuilder().build());
    }

    @Override
    public LifecycleHookFluent.ExecNewPodNested<A> editOrNewExecNewPodLike(ExecNewPodHook item) {
        return this.withNewExecNewPodLike(this.getExecNewPod() != null ? this.getExecNewPod() : item);
    }

    @Override
    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    @Override
    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    @Override
    public A addToTagImages(int index, TagImageHook item) {
        TagImageHookBuilder builder = new TagImageHookBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.tagImages.add(index >= 0 ? index : this.tagImages.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTagImages(int index, TagImageHook item) {
        TagImageHookBuilder builder = new TagImageHookBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.tagImages.size()) {
            this.tagImages.add(builder);
        } else {
            this.tagImages.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTagImages(TagImageHook ... items) {
        for (TagImageHook item : items) {
            TagImageHookBuilder builder = new TagImageHookBuilder(item);
            this._visitables.add(builder);
            this.tagImages.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTagImages(Collection<TagImageHook> items) {
        for (TagImageHook item : items) {
            TagImageHookBuilder builder = new TagImageHookBuilder(item);
            this._visitables.add(builder);
            this.tagImages.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTagImages(TagImageHook ... items) {
        for (TagImageHook item : items) {
            TagImageHookBuilder builder = new TagImageHookBuilder(item);
            this._visitables.remove(builder);
            this.tagImages.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTagImages(Collection<TagImageHook> items) {
        for (TagImageHook item : items) {
            TagImageHookBuilder builder = new TagImageHookBuilder(item);
            this._visitables.remove(builder);
            this.tagImages.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TagImageHook> getTagImages() {
        return LifecycleHookFluentImpl.build(this.tagImages);
    }

    @Override
    public List<TagImageHook> buildTagImages() {
        return LifecycleHookFluentImpl.build(this.tagImages);
    }

    @Override
    public TagImageHook buildTagImage(int index) {
        return this.tagImages.get(index).build();
    }

    @Override
    public TagImageHook buildFirstTagImage() {
        return this.tagImages.get(0).build();
    }

    @Override
    public TagImageHook buildLastTagImage() {
        return this.tagImages.get(this.tagImages.size() - 1).build();
    }

    @Override
    public TagImageHook buildMatchingTagImage(Predicate<TagImageHookBuilder> predicate) {
        for (TagImageHookBuilder item : this.tagImages) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withTagImages(List<TagImageHook> tagImages) {
        this._visitables.removeAll(this.tagImages);
        this.tagImages.clear();
        if (tagImages != null) {
            for (TagImageHook item : tagImages) {
                this.addToTagImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTagImages(TagImageHook ... tagImages) {
        this.tagImages.clear();
        if (tagImages != null) {
            for (TagImageHook item : tagImages) {
                this.addToTagImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTagImages() {
        return this.tagImages != null && !this.tagImages.isEmpty();
    }

    @Override
    public LifecycleHookFluent.TagImagesNested<A> addNewTagImage() {
        return new TagImagesNestedImpl();
    }

    @Override
    public LifecycleHookFluent.TagImagesNested<A> addNewTagImageLike(TagImageHook item) {
        return new TagImagesNestedImpl(-1, item);
    }

    @Override
    public LifecycleHookFluent.TagImagesNested<A> setNewTagImageLike(int index, TagImageHook item) {
        return new TagImagesNestedImpl(index, item);
    }

    @Override
    public LifecycleHookFluent.TagImagesNested<A> editTagImage(int index) {
        if (this.tagImages.size() <= index) {
            throw new RuntimeException("Can't edit tagImages. Index exceeds size.");
        }
        return this.setNewTagImageLike(index, this.buildTagImage(index));
    }

    @Override
    public LifecycleHookFluent.TagImagesNested<A> editFirstTagImage() {
        if (this.tagImages.size() == 0) {
            throw new RuntimeException("Can't edit first tagImages. The list is empty.");
        }
        return this.setNewTagImageLike(0, this.buildTagImage(0));
    }

    @Override
    public LifecycleHookFluent.TagImagesNested<A> editLastTagImage() {
        int index = this.tagImages.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tagImages. The list is empty.");
        }
        return this.setNewTagImageLike(index, this.buildTagImage(index));
    }

    @Override
    public LifecycleHookFluent.TagImagesNested<A> editMatchingTagImage(Predicate<TagImageHookBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tagImages.size(); ++i) {
            if (!predicate.apply(this.tagImages.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tagImages. No match found.");
        }
        return this.setNewTagImageLike(index, this.buildTagImage(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LifecycleHookFluentImpl that = (LifecycleHookFluentImpl)o;
        if (this.execNewPod != null ? !this.execNewPod.equals(that.execNewPod) : that.execNewPod != null) {
            return false;
        }
        if (this.failurePolicy != null ? !this.failurePolicy.equals(that.failurePolicy) : that.failurePolicy != null) {
            return false;
        }
        return !(this.tagImages != null ? !this.tagImages.equals(that.tagImages) : that.tagImages != null);
    }

    public class TagImagesNestedImpl<N>
    extends TagImageHookFluentImpl<LifecycleHookFluent.TagImagesNested<N>>
    implements LifecycleHookFluent.TagImagesNested<N>,
    Nested<N> {
        private final TagImageHookBuilder builder;
        private final int index;

        TagImagesNestedImpl(int index, TagImageHook item) {
            this.index = index;
            this.builder = new TagImageHookBuilder(this, item);
        }

        TagImagesNestedImpl() {
            this.index = -1;
            this.builder = new TagImageHookBuilder(this);
        }

        @Override
        public N and() {
            return (N)LifecycleHookFluentImpl.this.setToTagImages(this.index, this.builder.build());
        }

        @Override
        public N endTagImage() {
            return this.and();
        }
    }

    public class ExecNewPodNestedImpl<N>
    extends ExecNewPodHookFluentImpl<LifecycleHookFluent.ExecNewPodNested<N>>
    implements LifecycleHookFluent.ExecNewPodNested<N>,
    Nested<N> {
        private final ExecNewPodHookBuilder builder;

        ExecNewPodNestedImpl(ExecNewPodHook item) {
            this.builder = new ExecNewPodHookBuilder(this, item);
        }

        ExecNewPodNestedImpl() {
            this.builder = new ExecNewPodHookBuilder(this);
        }

        @Override
        public N and() {
            return (N)LifecycleHookFluentImpl.this.withExecNewPod(this.builder.build());
        }

        @Override
        public N endExecNewPod() {
            return this.and();
        }
    }
}

