/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import io.fabric8.kubernetes.api.model.v4_0.ListMeta;
import io.fabric8.kubernetes.api.model.v4_0.ListMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_0.ListMetaFluentImpl;
import io.fabric8.openshift.api.model.v4_0.DeploymentConfig;
import io.fabric8.openshift.api.model.v4_0.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.v4_0.DeploymentConfigFluentImpl;
import io.fabric8.openshift.api.model.v4_0.DeploymentConfigList;
import io.fabric8.openshift.api.model.v4_0.DeploymentConfigListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeploymentConfigListFluentImpl<A extends DeploymentConfigListFluent<A>>
extends BaseFluent<A>
implements DeploymentConfigListFluent<A> {
    private String apiVersion;
    private List<DeploymentConfigBuilder> items = new ArrayList<DeploymentConfigBuilder>();
    private String kind;
    private ListMetaBuilder metadata;

    public DeploymentConfigListFluentImpl() {
    }

    public DeploymentConfigListFluentImpl(DeploymentConfigList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, DeploymentConfig item) {
        DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, DeploymentConfig item) {
        DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(DeploymentConfig ... items) {
        for (DeploymentConfig item : items) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<DeploymentConfig> items) {
        for (DeploymentConfig item : items) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(DeploymentConfig ... items) {
        for (DeploymentConfig item : items) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<DeploymentConfig> items) {
        for (DeploymentConfig item : items) {
            DeploymentConfigBuilder builder = new DeploymentConfigBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DeploymentConfig> getItems() {
        return DeploymentConfigListFluentImpl.build(this.items);
    }

    @Override
    public List<DeploymentConfig> buildItems() {
        return DeploymentConfigListFluentImpl.build(this.items);
    }

    @Override
    public DeploymentConfig buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public DeploymentConfig buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public DeploymentConfig buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public DeploymentConfig buildMatchingItem(Predicate<DeploymentConfigBuilder> predicate) {
        for (DeploymentConfigBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withItems(List<DeploymentConfig> items) {
        this._visitables.removeAll(this.items);
        this.items.clear();
        if (items != null) {
            for (DeploymentConfig item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(DeploymentConfig ... items) {
        this.items.clear();
        if (items != null) {
            for (DeploymentConfig item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public DeploymentConfigListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public DeploymentConfigListFluent.ItemsNested<A> addNewItemLike(DeploymentConfig item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public DeploymentConfigListFluent.ItemsNested<A> setNewItemLike(int index, DeploymentConfig item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public DeploymentConfigListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public DeploymentConfigListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public DeploymentConfigListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public DeploymentConfigListFluent.ItemsNested<A> editMatchingItem(Predicate<DeploymentConfigBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ListMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public DeploymentConfigListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DeploymentConfigListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DeploymentConfigListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public DeploymentConfigListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ListMetaBuilder().build());
    }

    @Override
    public DeploymentConfigListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A withNewMetadata(String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigListFluentImpl that = (DeploymentConfigListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public class MetadataNestedImpl<N>
    extends ListMetaFluentImpl<DeploymentConfigListFluent.MetadataNested<N>>
    implements DeploymentConfigListFluent.MetadataNested<N>,
    Nested<N> {
        private final ListMetaBuilder builder;

        MetadataNestedImpl(ListMeta item) {
            this.builder = new ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ItemsNestedImpl<N>
    extends DeploymentConfigFluentImpl<DeploymentConfigListFluent.ItemsNested<N>>
    implements DeploymentConfigListFluent.ItemsNested<N>,
    Nested<N> {
        private final DeploymentConfigBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, DeploymentConfig item) {
            this.index = index;
            this.builder = new DeploymentConfigBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new DeploymentConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

