/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import io.fabric8.openshift.api.model.v4_0.ClusterRole;
import io.fabric8.openshift.api.model.v4_0.ClusterRoleFluent;
import io.fabric8.openshift.api.model.v4_0.ClusterRoleFluentImpl;

public class ClusterRoleBuilder
extends ClusterRoleFluentImpl<ClusterRoleBuilder>
implements VisitableBuilder<ClusterRole, ClusterRoleBuilder> {
    ClusterRoleFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterRoleBuilder() {
        this(true);
    }

    public ClusterRoleBuilder(Boolean validationEnabled) {
        this(new ClusterRole(), validationEnabled);
    }

    public ClusterRoleBuilder(ClusterRoleFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClusterRoleBuilder(ClusterRoleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterRole(), validationEnabled);
    }

    public ClusterRoleBuilder(ClusterRoleFluent<?> fluent, ClusterRole instance) {
        this(fluent, instance, true);
    }

    public ClusterRoleBuilder(ClusterRoleFluent<?> fluent, ClusterRole instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    public ClusterRoleBuilder(ClusterRole instance) {
        this(instance, (Boolean)true);
    }

    public ClusterRoleBuilder(ClusterRole instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ClusterRole build() {
        ClusterRole buildable = new ClusterRole(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRules());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterRoleBuilder that = (ClusterRoleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

