/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import io.fabric8.kubernetes.api.model.v4_0.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v4_0.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v4_0.ResourceRequirementsFluentImpl;
import io.fabric8.openshift.api.model.v4_0.BuildOutput;
import io.fabric8.openshift.api.model.v4_0.BuildOutputBuilder;
import io.fabric8.openshift.api.model.v4_0.BuildOutputFluentImpl;
import io.fabric8.openshift.api.model.v4_0.BuildPostCommitSpec;
import io.fabric8.openshift.api.model.v4_0.BuildPostCommitSpecBuilder;
import io.fabric8.openshift.api.model.v4_0.BuildPostCommitSpecFluentImpl;
import io.fabric8.openshift.api.model.v4_0.BuildSource;
import io.fabric8.openshift.api.model.v4_0.BuildSourceBuilder;
import io.fabric8.openshift.api.model.v4_0.BuildSourceFluentImpl;
import io.fabric8.openshift.api.model.v4_0.BuildSpec;
import io.fabric8.openshift.api.model.v4_0.BuildSpecFluent;
import io.fabric8.openshift.api.model.v4_0.BuildStrategy;
import io.fabric8.openshift.api.model.v4_0.BuildStrategyBuilder;
import io.fabric8.openshift.api.model.v4_0.BuildStrategyFluentImpl;
import io.fabric8.openshift.api.model.v4_0.BuildTriggerCause;
import io.fabric8.openshift.api.model.v4_0.BuildTriggerCauseBuilder;
import io.fabric8.openshift.api.model.v4_0.BuildTriggerCauseFluentImpl;
import io.fabric8.openshift.api.model.v4_0.SourceRevision;
import io.fabric8.openshift.api.model.v4_0.SourceRevisionBuilder;
import io.fabric8.openshift.api.model.v4_0.SourceRevisionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class BuildSpecFluentImpl<A extends BuildSpecFluent<A>>
extends BaseFluent<A>
implements BuildSpecFluent<A> {
    private Long completionDeadlineSeconds;
    private Map<String, String> nodeSelector = new LinkedHashMap<String, String>();
    private BuildOutputBuilder output;
    private BuildPostCommitSpecBuilder postCommit;
    private ResourceRequirementsBuilder resources;
    private SourceRevisionBuilder revision;
    private String serviceAccount;
    private BuildSourceBuilder source;
    private BuildStrategyBuilder strategy;
    private List<BuildTriggerCauseBuilder> triggeredBy = new ArrayList<BuildTriggerCauseBuilder>();

    public BuildSpecFluentImpl() {
    }

    public BuildSpecFluentImpl(BuildSpec instance) {
        this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds());
        this.withNodeSelector(instance.getNodeSelector());
        this.withOutput(instance.getOutput());
        this.withPostCommit(instance.getPostCommit());
        this.withResources(instance.getResources());
        this.withRevision(instance.getRevision());
        this.withServiceAccount(instance.getServiceAccount());
        this.withSource(instance.getSource());
        this.withStrategy(instance.getStrategy());
        this.withTriggeredBy(instance.getTriggeredBy());
    }

    @Override
    public Long getCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds;
    }

    @Override
    public A withCompletionDeadlineSeconds(Long completionDeadlineSeconds) {
        this.completionDeadlineSeconds = completionDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionDeadlineSeconds() {
        return this.completionDeadlineSeconds != null;
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (key != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector.clear();
        if (nodeSelector != null) {
            this.nodeSelector.putAll(nodeSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    @Deprecated
    public BuildOutput getOutput() {
        return this.output != null ? this.output.build() : null;
    }

    @Override
    public BuildOutput buildOutput() {
        return this.output != null ? this.output.build() : null;
    }

    @Override
    public A withOutput(BuildOutput output) {
        this._visitables.remove(this.output);
        if (output != null) {
            this.output = new BuildOutputBuilder(output);
            this._visitables.add(this.output);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutput() {
        return this.output != null;
    }

    @Override
    public BuildSpecFluent.OutputNested<A> withNewOutput() {
        return new OutputNestedImpl();
    }

    @Override
    public BuildSpecFluent.OutputNested<A> withNewOutputLike(BuildOutput item) {
        return new OutputNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.OutputNested<A> editOutput() {
        return this.withNewOutputLike(this.getOutput());
    }

    @Override
    public BuildSpecFluent.OutputNested<A> editOrNewOutput() {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : new BuildOutputBuilder().build());
    }

    @Override
    public BuildSpecFluent.OutputNested<A> editOrNewOutputLike(BuildOutput item) {
        return this.withNewOutputLike(this.getOutput() != null ? this.getOutput() : item);
    }

    @Override
    @Deprecated
    public BuildPostCommitSpec getPostCommit() {
        return this.postCommit != null ? this.postCommit.build() : null;
    }

    @Override
    public BuildPostCommitSpec buildPostCommit() {
        return this.postCommit != null ? this.postCommit.build() : null;
    }

    @Override
    public A withPostCommit(BuildPostCommitSpec postCommit) {
        this._visitables.remove(this.postCommit);
        if (postCommit != null) {
            this.postCommit = new BuildPostCommitSpecBuilder(postCommit);
            this._visitables.add(this.postCommit);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPostCommit() {
        return this.postCommit != null;
    }

    @Override
    public BuildSpecFluent.PostCommitNested<A> withNewPostCommit() {
        return new PostCommitNestedImpl();
    }

    @Override
    public BuildSpecFluent.PostCommitNested<A> withNewPostCommitLike(BuildPostCommitSpec item) {
        return new PostCommitNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.PostCommitNested<A> editPostCommit() {
        return this.withNewPostCommitLike(this.getPostCommit());
    }

    @Override
    public BuildSpecFluent.PostCommitNested<A> editOrNewPostCommit() {
        return this.withNewPostCommitLike(this.getPostCommit() != null ? this.getPostCommit() : new BuildPostCommitSpecBuilder().build());
    }

    @Override
    public BuildSpecFluent.PostCommitNested<A> editOrNewPostCommitLike(BuildPostCommitSpec item) {
        return this.withNewPostCommitLike(this.getPostCommit() != null ? this.getPostCommit() : item);
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.add(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public BuildSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public BuildSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public BuildSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public BuildSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    @Deprecated
    public SourceRevision getRevision() {
        return this.revision != null ? this.revision.build() : null;
    }

    @Override
    public SourceRevision buildRevision() {
        return this.revision != null ? this.revision.build() : null;
    }

    @Override
    public A withRevision(SourceRevision revision) {
        this._visitables.remove(this.revision);
        if (revision != null) {
            this.revision = new SourceRevisionBuilder(revision);
            this._visitables.add(this.revision);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRevision() {
        return this.revision != null;
    }

    @Override
    public BuildSpecFluent.RevisionNested<A> withNewRevision() {
        return new RevisionNestedImpl();
    }

    @Override
    public BuildSpecFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item) {
        return new RevisionNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.RevisionNested<A> editRevision() {
        return this.withNewRevisionLike(this.getRevision());
    }

    @Override
    public BuildSpecFluent.RevisionNested<A> editOrNewRevision() {
        return this.withNewRevisionLike(this.getRevision() != null ? this.getRevision() : new SourceRevisionBuilder().build());
    }

    @Override
    public BuildSpecFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item) {
        return this.withNewRevisionLike(this.getRevision() != null ? this.getRevision() : item);
    }

    @Override
    public String getServiceAccount() {
        return this.serviceAccount;
    }

    @Override
    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    @Override
    @Deprecated
    public BuildSource getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public BuildSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(BuildSource source) {
        this._visitables.remove(this.source);
        if (source != null) {
            this.source = new BuildSourceBuilder(source);
            this._visitables.add(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public BuildSpecFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public BuildSpecFluent.SourceNested<A> withNewSourceLike(BuildSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public BuildSpecFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new BuildSourceBuilder().build());
    }

    @Override
    public BuildSpecFluent.SourceNested<A> editOrNewSourceLike(BuildSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    @Deprecated
    public BuildStrategy getStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public BuildStrategy buildStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public A withStrategy(BuildStrategy strategy) {
        this._visitables.remove(this.strategy);
        if (strategy != null) {
            this.strategy = new BuildStrategyBuilder(strategy);
            this._visitables.add(this.strategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    public BuildSpecFluent.StrategyNested<A> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public BuildSpecFluent.StrategyNested<A> withNewStrategyLike(BuildStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public BuildSpecFluent.StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public BuildSpecFluent.StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : new BuildStrategyBuilder().build());
    }

    @Override
    public BuildSpecFluent.StrategyNested<A> editOrNewStrategyLike(BuildStrategy item) {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : item);
    }

    @Override
    public A addToTriggeredBy(int index, BuildTriggerCause item) {
        BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.triggeredBy.add(index >= 0 ? index : this.triggeredBy.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTriggeredBy(int index, BuildTriggerCause item) {
        BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.triggeredBy.size()) {
            this.triggeredBy.add(builder);
        } else {
            this.triggeredBy.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTriggeredBy(BuildTriggerCause ... items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.add(builder);
            this.triggeredBy.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTriggeredBy(Collection<BuildTriggerCause> items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.add(builder);
            this.triggeredBy.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTriggeredBy(BuildTriggerCause ... items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.remove(builder);
            this.triggeredBy.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTriggeredBy(Collection<BuildTriggerCause> items) {
        for (BuildTriggerCause item : items) {
            BuildTriggerCauseBuilder builder = new BuildTriggerCauseBuilder(item);
            this._visitables.remove(builder);
            this.triggeredBy.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BuildTriggerCause> getTriggeredBy() {
        return BuildSpecFluentImpl.build(this.triggeredBy);
    }

    @Override
    public List<BuildTriggerCause> buildTriggeredBy() {
        return BuildSpecFluentImpl.build(this.triggeredBy);
    }

    @Override
    public BuildTriggerCause buildTriggeredBy(int index) {
        return this.triggeredBy.get(index).build();
    }

    @Override
    public BuildTriggerCause buildFirstTriggeredBy() {
        return this.triggeredBy.get(0).build();
    }

    @Override
    public BuildTriggerCause buildLastTriggeredBy() {
        return this.triggeredBy.get(this.triggeredBy.size() - 1).build();
    }

    @Override
    public BuildTriggerCause buildMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        for (BuildTriggerCauseBuilder item : this.triggeredBy) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withTriggeredBy(List<BuildTriggerCause> triggeredBy) {
        this._visitables.removeAll(this.triggeredBy);
        this.triggeredBy.clear();
        if (triggeredBy != null) {
            for (BuildTriggerCause item : triggeredBy) {
                this.addToTriggeredBy(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withTriggeredBy(BuildTriggerCause ... triggeredBy) {
        this.triggeredBy.clear();
        if (triggeredBy != null) {
            for (BuildTriggerCause item : triggeredBy) {
                this.addToTriggeredBy(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTriggeredBy() {
        return this.triggeredBy != null && !this.triggeredBy.isEmpty();
    }

    @Override
    public BuildSpecFluent.TriggeredByNested<A> addNewTriggeredBy() {
        return new TriggeredByNestedImpl();
    }

    @Override
    public BuildSpecFluent.TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item) {
        return new TriggeredByNestedImpl(-1, item);
    }

    @Override
    public BuildSpecFluent.TriggeredByNested<A> setNewTriggeredByLike(int index, BuildTriggerCause item) {
        return new TriggeredByNestedImpl(index, item);
    }

    @Override
    public BuildSpecFluent.TriggeredByNested<A> editTriggeredBy(int index) {
        if (this.triggeredBy.size() <= index) {
            throw new RuntimeException("Can't edit triggeredBy. Index exceeds size.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    @Override
    public BuildSpecFluent.TriggeredByNested<A> editFirstTriggeredBy() {
        if (this.triggeredBy.size() == 0) {
            throw new RuntimeException("Can't edit first triggeredBy. The list is empty.");
        }
        return this.setNewTriggeredByLike(0, this.buildTriggeredBy(0));
    }

    @Override
    public BuildSpecFluent.TriggeredByNested<A> editLastTriggeredBy() {
        int index = this.triggeredBy.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last triggeredBy. The list is empty.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    @Override
    public BuildSpecFluent.TriggeredByNested<A> editMatchingTriggeredBy(Predicate<BuildTriggerCauseBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.triggeredBy.size(); ++i) {
            if (!predicate.apply(this.triggeredBy.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching triggeredBy. No match found.");
        }
        return this.setNewTriggeredByLike(index, this.buildTriggeredBy(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildSpecFluentImpl that = (BuildSpecFluentImpl)o;
        if (this.completionDeadlineSeconds != null ? !this.completionDeadlineSeconds.equals(that.completionDeadlineSeconds) : that.completionDeadlineSeconds != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.output != null ? !this.output.equals(that.output) : that.output != null) {
            return false;
        }
        if (this.postCommit != null ? !this.postCommit.equals(that.postCommit) : that.postCommit != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        if (this.serviceAccount != null ? !this.serviceAccount.equals(that.serviceAccount) : that.serviceAccount != null) {
            return false;
        }
        if (this.source != null ? !this.source.equals(that.source) : that.source != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.triggeredBy != null ? !this.triggeredBy.equals(that.triggeredBy) : that.triggeredBy != null);
    }

    public class TriggeredByNestedImpl<N>
    extends BuildTriggerCauseFluentImpl<BuildSpecFluent.TriggeredByNested<N>>
    implements BuildSpecFluent.TriggeredByNested<N>,
    Nested<N> {
        private final BuildTriggerCauseBuilder builder;
        private final int index;

        TriggeredByNestedImpl(int index, BuildTriggerCause item) {
            this.index = index;
            this.builder = new BuildTriggerCauseBuilder(this, item);
        }

        TriggeredByNestedImpl() {
            this.index = -1;
            this.builder = new BuildTriggerCauseBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.setToTriggeredBy(this.index, this.builder.build());
        }

        @Override
        public N endTriggeredBy() {
            return this.and();
        }
    }

    public class StrategyNestedImpl<N>
    extends BuildStrategyFluentImpl<BuildSpecFluent.StrategyNested<N>>
    implements BuildSpecFluent.StrategyNested<N>,
    Nested<N> {
        private final BuildStrategyBuilder builder;

        StrategyNestedImpl(BuildStrategy item) {
            this.builder = new BuildStrategyBuilder(this, item);
        }

        StrategyNestedImpl() {
            this.builder = new BuildStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withStrategy(this.builder.build());
        }

        @Override
        public N endStrategy() {
            return this.and();
        }
    }

    public class SourceNestedImpl<N>
    extends BuildSourceFluentImpl<BuildSpecFluent.SourceNested<N>>
    implements BuildSpecFluent.SourceNested<N>,
    Nested<N> {
        private final BuildSourceBuilder builder;

        SourceNestedImpl(BuildSource item) {
            this.builder = new BuildSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new BuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }

    public class RevisionNestedImpl<N>
    extends SourceRevisionFluentImpl<BuildSpecFluent.RevisionNested<N>>
    implements BuildSpecFluent.RevisionNested<N>,
    Nested<N> {
        private final SourceRevisionBuilder builder;

        RevisionNestedImpl(SourceRevision item) {
            this.builder = new SourceRevisionBuilder(this, item);
        }

        RevisionNestedImpl() {
            this.builder = new SourceRevisionBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withRevision(this.builder.build());
        }

        @Override
        public N endRevision() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<BuildSpecFluent.ResourcesNested<N>>
    implements BuildSpecFluent.ResourcesNested<N>,
    Nested<N> {
        private final ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    public class PostCommitNestedImpl<N>
    extends BuildPostCommitSpecFluentImpl<BuildSpecFluent.PostCommitNested<N>>
    implements BuildSpecFluent.PostCommitNested<N>,
    Nested<N> {
        private final BuildPostCommitSpecBuilder builder;

        PostCommitNestedImpl(BuildPostCommitSpec item) {
            this.builder = new BuildPostCommitSpecBuilder(this, item);
        }

        PostCommitNestedImpl() {
            this.builder = new BuildPostCommitSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withPostCommit(this.builder.build());
        }

        @Override
        public N endPostCommit() {
            return this.and();
        }
    }

    public class OutputNestedImpl<N>
    extends BuildOutputFluentImpl<BuildSpecFluent.OutputNested<N>>
    implements BuildSpecFluent.OutputNested<N>,
    Nested<N> {
        private final BuildOutputBuilder builder;

        OutputNestedImpl(BuildOutput item) {
            this.builder = new BuildOutputBuilder(this, item);
        }

        OutputNestedImpl() {
            this.builder = new BuildOutputBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSpecFluentImpl.this.withOutput(this.builder.build());
        }

        @Override
        public N endOutput() {
            return this.and();
        }
    }
}

