/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_0.utils;

import java.net.URI;
import java.net.URISyntaxException;

public class URLUtils {
    private URLUtils() {
    }

    public static String join(String ... parts) {
        StringBuilder sb = new StringBuilder();
        String queryParams = "";
        if (parts.length > 0) {
            String urlWithoutQuery = parts[0];
            try {
                URI uri = new URI(parts[0]);
                if (uri.getQuery() != null) {
                    queryParams = "?" + uri.getQuery();
                    urlWithoutQuery = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment()).toString();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            sb.append(urlWithoutQuery).append("/");
        }
        for (int i = 1; i < parts.length; ++i) {
            sb.append(parts[i]);
            if (i >= parts.length - 1) continue;
            sb.append("/");
        }
        sb.append(queryParams);
        String joined = sb.toString();
        return joined.replaceAll("/+", "/").replaceAll("/\\?", "?").replaceAll("/#", "#").replaceAll(":/", "://");
    }
}

