/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_0.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.v4_0.KubernetesList;
import io.fabric8.kubernetes.api.model.v4_0.KubernetesResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class KubernetesDeserializer
extends JsonDeserializer<KubernetesResource> {
    private static final String KIND = "kind";
    private static final String KUBERNETES_PACKAGE_PREFIX = "io.fabric8.kubernetes.api.model.v4_0.";
    private static final String KUBERNETES_EXTENSIONS_PACKAGE_PREFIX = "io.fabric8.kubernetes.api.model.v4_0.extensions.";
    private static final String KUBERNETES_APIEXTENSIONS_PACKAGE_PREFIX = "io.fabric8.kubernetes.api.model.v4_0.apiextensions.";
    private static final String OPENSHIFT_PACKAGE_PREFIX = "io.fabric8.openshift.api.model.v4_0.";
    private static final Map<String, Class<? extends KubernetesResource>> MAP = new HashMap<String, Class<? extends KubernetesResource>>();

    public KubernetesResource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = (ObjectNode)jp.readValueAsTree();
        JsonNode kind = node.get(KIND);
        if (kind != null) {
            String value = kind.textValue();
            Class resourceType = KubernetesDeserializer.getTypeForName(value);
            if (resourceType == null) {
                throw ctxt.mappingException("No resource type found for kind:" + value);
            }
            return (KubernetesResource)jp.getCodec().treeToValue((TreeNode)node, resourceType);
        }
        return null;
    }

    public static void registerCustomKind(String kind, Class<? extends KubernetesResource> clazz) {
        MAP.put(kind, clazz);
    }

    private static Class getTypeForName(String name) {
        Class result = MAP.get(name);
        if (result == null && (result = KubernetesDeserializer.loadClassIfExists(KUBERNETES_PACKAGE_PREFIX + name)) == null && (result = KubernetesDeserializer.loadClassIfExists(KUBERNETES_EXTENSIONS_PACKAGE_PREFIX + name)) == null && (result = KubernetesDeserializer.loadClassIfExists(OPENSHIFT_PACKAGE_PREFIX + name)) == null) {
            result = KubernetesDeserializer.loadClassIfExists(KUBERNETES_APIEXTENSIONS_PACKAGE_PREFIX + name);
        }
        if (result != null) {
            MAP.put(name, result);
        }
        return result;
    }

    private static Class loadClassIfExists(String className) {
        try {
            return KubernetesDeserializer.class.getClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        MAP.put("List", KubernetesList.class);
    }
}

