/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_0.dsl.internal;

import io.fabric8.kubernetes.api.model.v4_0.LabelSelectorRequirement;
import io.fabric8.kubernetes.api.model.v4_0.PodList;
import io.fabric8.kubernetes.api.model.v4_0.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v4_0.extensions.DoneableStatefulSet;
import io.fabric8.kubernetes.api.model.v4_0.extensions.StatefulSet;
import io.fabric8.kubernetes.api.model.v4_0.extensions.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.v4_0.extensions.StatefulSetFluent;
import io.fabric8.kubernetes.api.model.v4_0.extensions.StatefulSetList;
import io.fabric8.kubernetes.api.model.v4_0.extensions.StatefulSetSpecFluent;
import io.fabric8.kubernetes.clnt.v4_0.Config;
import io.fabric8.kubernetes.clnt.v4_0.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.clnt.v4_0.dsl.Operation;
import io.fabric8.kubernetes.clnt.v4_0.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v4_0.dsl.internal.RollingUpdater;
import io.fabric8.kubernetes.clnt.v4_0.dsl.internal.StatefulSetOperationsImpl;
import okhttp3.OkHttpClient;

class StatefulSetRollingUpdater
extends RollingUpdater<StatefulSet, StatefulSetList, DoneableStatefulSet> {
    StatefulSetRollingUpdater(OkHttpClient client, Config config, String namespace) {
        super(client, config, namespace);
    }

    StatefulSetRollingUpdater(OkHttpClient client, Config config, String namespace, long rollingTimeoutMillis, long loggingIntervalMillis) {
        super(client, config, namespace, rollingTimeoutMillis, loggingIntervalMillis);
    }

    @Override
    protected StatefulSet createClone(StatefulSet obj, String newName, String newDeploymentHash) {
        return ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)((StatefulSetFluent.SpecNested)((StatefulSetBuilder)((StatefulSetFluent.MetadataNested)((StatefulSetFluent.MetadataNested)new StatefulSetBuilder(obj).editMetadata().withResourceVersion(null)).withName(newName)).endMetadata()).editSpec().withReplicas(0)).editSelector().addToMatchLabels("deployment", newDeploymentHash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", newDeploymentHash)).endMetadata()).endTemplate()).endSpec()).build();
    }

    @Override
    protected PodList listSelectedPods(StatefulSet obj) {
        FilterWatchListDeletable podLister = (FilterWatchListDeletable)this.pods().inNamespace(this.namespace);
        if (obj.getSpec().getSelector().getMatchLabels() != null) {
            podLister.withLabels(obj.getSpec().getSelector().getMatchLabels());
        }
        if (obj.getSpec().getSelector().getMatchExpressions() != null) {
            for (LabelSelectorRequirement req : obj.getSpec().getSelector().getMatchExpressions()) {
                switch (req.getOperator()) {
                    case "In": {
                        podLister.withLabelIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "NotIn": {
                        podLister.withLabelNotIn(req.getKey(), req.getValues().toArray(new String[0]));
                        break;
                    }
                    case "DoesNotExist": {
                        podLister.withoutLabel(req.getKey());
                        break;
                    }
                    case "Exists": {
                        podLister.withLabel(req.getKey());
                    }
                }
            }
        }
        return (PodList)podLister.list();
    }

    @Override
    protected void updateDeploymentKey(DoneableStatefulSet obj, String hash) {
        ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)obj.editSpec().editSelector().addToMatchLabels("deployment", hash)).endSelector()).editTemplate().editMetadata().addToLabels("deployment", hash)).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected void removeDeploymentKey(DoneableStatefulSet obj) {
        ((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.MetadataNested)((StatefulSetFluent.SpecNested)((StatefulSetSpecFluent.SelectorNested)obj.editSpec().editSelector().removeFromMatchLabels("deployment")).endSelector()).editTemplate().editMetadata().removeFromLabels("deployment")).endMetadata()).endTemplate()).endSpec();
    }

    @Override
    protected int getReplicas(StatefulSet obj) {
        return obj.getSpec().getReplicas();
    }

    @Override
    protected StatefulSet setReplicas(StatefulSet obj, int replicas) {
        return ((StatefulSetBuilder)((StatefulSetFluent.SpecNested)new StatefulSetBuilder(obj).editSpec().withReplicas(replicas)).endSpec()).build();
    }

    @Override
    protected Operation<StatefulSet, StatefulSetList, DoneableStatefulSet, RollableScalableResource<StatefulSet, DoneableStatefulSet>> resources() {
        return new StatefulSetOperationsImpl(this.client, this.config, this.namespace);
    }
}

