/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.clnt.v4_0.RequestConfig;
import io.fabric8.kubernetes.clnt.v4_0.RequestConfigFluent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RequestConfigFluentImpl<A extends RequestConfigFluent<A>>
extends BaseFluent<A>
implements RequestConfigFluent<A> {
    private String username;
    private String password;
    private String oauthToken;
    private String impersonateUsername;
    private List<String> impersonateGroups = new ArrayList<String>();
    private Map<String, String> impersonateExtras = new LinkedHashMap<String, String>();
    private int watchReconnectInterval;
    private int watchReconnectLimit;
    private int connectionTimeout;
    private int requestTimeout;
    private long rollingTimeout;
    private long scaleTimeout;
    private int loggingInterval;
    private long websocketTimeout;
    private long websocketPingInterval;
    private int maxConcurrentRequests;
    private int maxConcurrentRequestsPerHost;

    public RequestConfigFluentImpl() {
    }

    public RequestConfigFluentImpl(RequestConfig instance) {
        this.withUsername(instance.getUsername());
        this.withPassword(instance.getPassword());
        this.withOauthToken(instance.getOauthToken());
        this.withWatchReconnectLimit(instance.getWatchReconnectLimit());
        this.withWatchReconnectInterval(instance.getWatchReconnectInterval());
        this.withConnectionTimeout(instance.getConnectionTimeout());
        this.withRollingTimeout(instance.getRollingTimeout());
        this.withRequestTimeout(instance.getRequestTimeout());
        this.withScaleTimeout(instance.getScaleTimeout());
        this.withLoggingInterval(instance.getLoggingInterval());
        this.withWebsocketTimeout(instance.getWebsocketTimeout());
        this.withWebsocketPingInterval(instance.getWebsocketPingInterval());
        this.withMaxConcurrentRequests(instance.getMaxConcurrentRequests());
        this.withMaxConcurrentRequestsPerHost(instance.getMaxConcurrentRequestsPerHost());
        this.withImpersonateUsername(instance.getImpersonateUsername());
        this.withImpersonateGroups(instance.getImpersonateGroups());
        this.withImpersonateExtras(instance.getImpersonateExtras());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    @Override
    public String getOauthToken() {
        return this.oauthToken;
    }

    @Override
    public A withOauthToken(String oauthToken) {
        this.oauthToken = oauthToken;
        return (A)this;
    }

    @Override
    public String getImpersonateUsername() {
        return this.impersonateUsername;
    }

    @Override
    public A withImpersonateUsername(String impersonateUsername) {
        this.impersonateUsername = impersonateUsername;
        return (A)this;
    }

    @Override
    public A withImpersonateGroups(String ... impersonateGroups) {
        this.impersonateGroups.clear();
        if (impersonateGroups != null) {
            for (String item : impersonateGroups) {
                this.addToImpersonateGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getImpersonateGroups() {
        String[] result = new String[this.impersonateGroups.size()];
        int index = 0;
        for (String item : this.impersonateGroups) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToImpersonateGroups(String ... items) {
        for (String item : items) {
            this.impersonateGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateGroups(String ... items) {
        for (String item : items) {
            this.impersonateGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A addToImpersonateExtras(String key, String value) {
        if (key != null && value != null) {
            this.impersonateExtras.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToImpersonateExtras(Map<String, String> map) {
        if (map != null) {
            this.impersonateExtras.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateExtras(String key) {
        if (key != null) {
            this.impersonateExtras.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromImpersonateExtras(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.impersonateExtras.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getImpersonateExtras() {
        return this.impersonateExtras;
    }

    @Override
    public A withImpersonateExtras(Map<String, String> impersonateExtras) {
        this.impersonateExtras.clear();
        if (impersonateExtras != null) {
            this.impersonateExtras.putAll(impersonateExtras);
        }
        return (A)this;
    }

    @Override
    public int getWatchReconnectInterval() {
        return this.watchReconnectInterval;
    }

    @Override
    public A withWatchReconnectInterval(int watchReconnectInterval) {
        this.watchReconnectInterval = watchReconnectInterval;
        return (A)this;
    }

    @Override
    public int getWatchReconnectLimit() {
        return this.watchReconnectLimit;
    }

    @Override
    public A withWatchReconnectLimit(int watchReconnectLimit) {
        this.watchReconnectLimit = watchReconnectLimit;
        return (A)this;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public A withConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return (A)this;
    }

    @Override
    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    @Override
    public A withRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
        return (A)this;
    }

    @Override
    public long getRollingTimeout() {
        return this.rollingTimeout;
    }

    @Override
    public A withRollingTimeout(long rollingTimeout) {
        this.rollingTimeout = rollingTimeout;
        return (A)this;
    }

    @Override
    public long getScaleTimeout() {
        return this.scaleTimeout;
    }

    @Override
    public A withScaleTimeout(long scaleTimeout) {
        this.scaleTimeout = scaleTimeout;
        return (A)this;
    }

    @Override
    public int getLoggingInterval() {
        return this.loggingInterval;
    }

    @Override
    public A withLoggingInterval(int loggingInterval) {
        this.loggingInterval = loggingInterval;
        return (A)this;
    }

    @Override
    public long getWebsocketTimeout() {
        return this.websocketTimeout;
    }

    @Override
    public A withWebsocketTimeout(long websocketTimeout) {
        this.websocketTimeout = websocketTimeout;
        return (A)this;
    }

    @Override
    public long getWebsocketPingInterval() {
        return this.websocketPingInterval;
    }

    @Override
    public A withWebsocketPingInterval(long websocketPingInterval) {
        this.websocketPingInterval = websocketPingInterval;
        return (A)this;
    }

    @Override
    public int getMaxConcurrentRequests() {
        return this.maxConcurrentRequests;
    }

    @Override
    public A withMaxConcurrentRequests(int maxConcurrentRequests) {
        this.maxConcurrentRequests = maxConcurrentRequests;
        return (A)this;
    }

    @Override
    public int getMaxConcurrentRequestsPerHost() {
        return this.maxConcurrentRequestsPerHost;
    }

    @Override
    public A withMaxConcurrentRequestsPerHost(int maxConcurrentRequestsPerHost) {
        this.maxConcurrentRequestsPerHost = maxConcurrentRequestsPerHost;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestConfigFluentImpl that = (RequestConfigFluentImpl)o;
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.oauthToken != null ? !this.oauthToken.equals(that.oauthToken) : that.oauthToken != null) {
            return false;
        }
        if (this.impersonateUsername != null ? !this.impersonateUsername.equals(that.impersonateUsername) : that.impersonateUsername != null) {
            return false;
        }
        if (this.impersonateGroups != null ? !this.impersonateGroups.equals(that.impersonateGroups) : that.impersonateGroups != null) {
            return false;
        }
        if (this.impersonateExtras != null ? !this.impersonateExtras.equals(that.impersonateExtras) : that.impersonateExtras != null) {
            return false;
        }
        if (this.watchReconnectInterval != that.watchReconnectInterval) {
            return false;
        }
        if (this.watchReconnectLimit != that.watchReconnectLimit) {
            return false;
        }
        if (this.connectionTimeout != that.connectionTimeout) {
            return false;
        }
        if (this.requestTimeout != that.requestTimeout) {
            return false;
        }
        if (this.rollingTimeout != that.rollingTimeout) {
            return false;
        }
        if (this.scaleTimeout != that.scaleTimeout) {
            return false;
        }
        if (this.loggingInterval != that.loggingInterval) {
            return false;
        }
        if (this.websocketTimeout != that.websocketTimeout) {
            return false;
        }
        if (this.websocketPingInterval != that.websocketPingInterval) {
            return false;
        }
        if (this.maxConcurrentRequests != that.maxConcurrentRequests) {
            return false;
        }
        return this.maxConcurrentRequestsPerHost == that.maxConcurrentRequestsPerHost;
    }
}

