/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.model.v4_0.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.v4_0.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v4_0.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v4_0.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.v4_0.ReplicationControllerSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;

public class ReplicationControllerSpecFluentImpl<A extends ReplicationControllerSpecFluent<A>>
extends BaseFluent<A>
implements ReplicationControllerSpecFluent<A> {
    private Integer minReadySeconds;
    private Integer replicas;
    private Map<String, String> selector = new LinkedHashMap<String, String>();
    private PodTemplateSpecBuilder template;

    public ReplicationControllerSpecFluentImpl() {
    }

    public ReplicationControllerSpecFluentImpl(ReplicationControllerSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withReplicas(instance.getReplicas());
        this.withSelector(instance.getSelector());
        this.withTemplate(instance.getTemplate());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A addToSelector(String key, String value) {
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (key != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public A withSelector(Map<String, String> selector) {
        this.selector.clear();
        if (selector != null) {
            this.selector.putAll(selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.add(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public ReplicationControllerSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicationControllerSpecFluentImpl that = (ReplicationControllerSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        return !(this.template != null ? !this.template.equals(that.template) : that.template != null);
    }

    public class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<ReplicationControllerSpecFluent.TemplateNested<N>>
    implements ReplicationControllerSpecFluent.TemplateNested<N>,
    Nested<N> {
        private final PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ReplicationControllerSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }
}

