/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v4_0.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v4_0.Event;
import io.fabric8.kubernetes.api.model.v4_0.EventFluent;
import io.fabric8.kubernetes.api.model.v4_0.EventFluentImpl;

public class EventBuilder
extends EventFluentImpl<EventBuilder>
implements VisitableBuilder<Event, EventBuilder> {
    EventFluent<?> fluent;
    Boolean validationEnabled;

    public EventBuilder() {
        this(true);
    }

    public EventBuilder(Boolean validationEnabled) {
        this(new Event(), validationEnabled);
    }

    public EventBuilder(EventFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EventBuilder(EventFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Event(), validationEnabled);
    }

    public EventBuilder(EventFluent<?> fluent, Event instance) {
        this(fluent, instance, true);
    }

    public EventBuilder(EventFluent<?> fluent, Event instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withCount(instance.getCount());
        fluent.withFirstTimestamp(instance.getFirstTimestamp());
        fluent.withInvolvedObject(instance.getInvolvedObject());
        fluent.withKind(instance.getKind());
        fluent.withLastTimestamp(instance.getLastTimestamp());
        fluent.withMessage(instance.getMessage());
        fluent.withMetadata(instance.getMetadata());
        fluent.withReason(instance.getReason());
        fluent.withSource(instance.getSource());
        fluent.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    public EventBuilder(Event instance) {
        this(instance, (Boolean)true);
    }

    public EventBuilder(Event instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withCount(instance.getCount());
        this.withFirstTimestamp(instance.getFirstTimestamp());
        this.withInvolvedObject(instance.getInvolvedObject());
        this.withKind(instance.getKind());
        this.withLastTimestamp(instance.getLastTimestamp());
        this.withMessage(instance.getMessage());
        this.withMetadata(instance.getMetadata());
        this.withReason(instance.getReason());
        this.withSource(instance.getSource());
        this.withType(instance.getType());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Event build() {
        Event buildable = new Event(this.fluent.getApiVersion(), this.fluent.getCount(), this.fluent.getFirstTimestamp(), this.fluent.getInvolvedObject(), this.fluent.getKind(), this.fluent.getLastTimestamp(), this.fluent.getMessage(), this.fluent.getMetadata(), this.fluent.getReason(), this.fluent.getSource(), this.fluent.getType());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EventBuilder that = (EventBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

