/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.SecurityContextConstraints;
import io.fabric8.openshift.api.model.SecurityContextConstraintsFluent;
import io.fabric8.openshift.api.model.SecurityContextConstraintsFluentImpl;

public class SecurityContextConstraintsBuilder
extends SecurityContextConstraintsFluentImpl<SecurityContextConstraintsBuilder>
implements VisitableBuilder<SecurityContextConstraints, SecurityContextConstraintsBuilder> {
    SecurityContextConstraintsFluent<?> fluent;
    Boolean validationEnabled;

    public SecurityContextConstraintsBuilder() {
        this(true);
    }

    public SecurityContextConstraintsBuilder(Boolean validationEnabled) {
        this(new SecurityContextConstraints(), validationEnabled);
    }

    public SecurityContextConstraintsBuilder(SecurityContextConstraintsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SecurityContextConstraintsBuilder(SecurityContextConstraintsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecurityContextConstraints(), validationEnabled);
    }

    public SecurityContextConstraintsBuilder(SecurityContextConstraintsFluent<?> fluent, SecurityContextConstraints instance) {
        this(fluent, instance, true);
    }

    public SecurityContextConstraintsBuilder(SecurityContextConstraintsFluent<?> fluent, SecurityContextConstraints instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin());
        fluent.withAllowHostIPC(instance.getAllowHostIPC());
        fluent.withAllowHostNetwork(instance.getAllowHostNetwork());
        fluent.withAllowHostPID(instance.getAllowHostPID());
        fluent.withAllowHostPorts(instance.getAllowHostPorts());
        fluent.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer());
        fluent.withAllowedCapabilities(instance.getAllowedCapabilities());
        fluent.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        fluent.withFsGroup(instance.getFsGroup());
        fluent.withGroups(instance.getGroups());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withPriority(instance.getPriority());
        fluent.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        fluent.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        fluent.withRunAsUser(instance.getRunAsUser());
        fluent.withSeLinuxContext(instance.getSeLinuxContext());
        fluent.withSeccompProfiles(instance.getSeccompProfiles());
        fluent.withSupplementalGroups(instance.getSupplementalGroups());
        fluent.withUsers(instance.getUsers());
        fluent.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    public SecurityContextConstraintsBuilder(SecurityContextConstraints instance) {
        this(instance, (Boolean)true);
    }

    public SecurityContextConstraintsBuilder(SecurityContextConstraints instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin());
        this.withAllowHostIPC(instance.getAllowHostIPC());
        this.withAllowHostNetwork(instance.getAllowHostNetwork());
        this.withAllowHostPID(instance.getAllowHostPID());
        this.withAllowHostPorts(instance.getAllowHostPorts());
        this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer());
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withAllowedFlexVolumes(instance.getAllowedFlexVolumes());
        this.withApiVersion(instance.getApiVersion());
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        this.withFsGroup(instance.getFsGroup());
        this.withGroups(instance.getGroups());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withPriority(instance.getPriority());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxContext(instance.getSeLinuxContext());
        this.withSeccompProfiles(instance.getSeccompProfiles());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withUsers(instance.getUsers());
        this.withVolumes(instance.getVolumes());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SecurityContextConstraints build() {
        SecurityContextConstraints buildable = new SecurityContextConstraints(this.fluent.isAllowHostDirVolumePlugin(), this.fluent.isAllowHostIPC(), this.fluent.isAllowHostNetwork(), this.fluent.isAllowHostPID(), this.fluent.isAllowHostPorts(), this.fluent.isAllowPrivilegedContainer(), this.fluent.getAllowedCapabilities(), this.fluent.getAllowedFlexVolumes(), this.fluent.getApiVersion(), this.fluent.getDefaultAddCapabilities(), this.fluent.getFsGroup(), this.fluent.getGroups(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getPriority(), this.fluent.isReadOnlyRootFilesystem(), this.fluent.getRequiredDropCapabilities(), this.fluent.getRunAsUser(), this.fluent.getSeLinuxContext(), this.fluent.getSeccompProfiles(), this.fluent.getSupplementalGroups(), this.fluent.getUsers(), this.fluent.getVolumes());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityContextConstraintsBuilder that = (SecurityContextConstraintsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

