/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import io.fabric8.openshift.api.model.Image;
import io.fabric8.openshift.api.model.ImageLookupPolicy;
import io.fabric8.openshift.api.model.TagEventCondition;
import io.fabric8.openshift.api.model.TagReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "conditions", "generation", "image", "lookupPolicy", "tag"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class ImageStreamTag
implements HasMetadata {
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "image.openshift.io/v1";
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Valid
    private List<TagEventCondition> conditions = new ArrayList<TagEventCondition>();
    @JsonProperty(value="generation")
    private Long generation;
    @JsonProperty(value="image")
    @Valid
    private Image image;
    @NotNull
    @JsonProperty(value="kind")
    private String kind = "ImageStreamTag";
    @JsonProperty(value="lookupPolicy")
    @Valid
    private ImageLookupPolicy lookupPolicy;
    @JsonProperty(value="metadata")
    @Valid
    @CheckObjectMeta(minimal=true)
    private ObjectMeta metadata;
    @JsonProperty(value="tag")
    @Valid
    private TagReference tag;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ImageStreamTag() {
    }

    public ImageStreamTag(String apiVersion, List<TagEventCondition> conditions, Long generation, Image image, String kind, ImageLookupPolicy lookupPolicy, ObjectMeta metadata, TagReference tag) {
        this.apiVersion = apiVersion;
        this.conditions = conditions;
        this.generation = generation;
        this.image = image;
        this.kind = kind;
        this.lookupPolicy = lookupPolicy;
        this.metadata = metadata;
        this.tag = tag;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="conditions")
    public List<TagEventCondition> getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="conditions")
    public void setConditions(List<TagEventCondition> conditions) {
        this.conditions = conditions;
    }

    @JsonProperty(value="generation")
    public Long getGeneration() {
        return this.generation;
    }

    @JsonProperty(value="generation")
    public void setGeneration(Long generation) {
        this.generation = generation;
    }

    @JsonProperty(value="image")
    public Image getImage() {
        return this.image;
    }

    @JsonProperty(value="image")
    public void setImage(Image image) {
        this.image = image;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="lookupPolicy")
    public ImageLookupPolicy getLookupPolicy() {
        return this.lookupPolicy;
    }

    @JsonProperty(value="lookupPolicy")
    public void setLookupPolicy(ImageLookupPolicy lookupPolicy) {
        this.lookupPolicy = lookupPolicy;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="tag")
    public TagReference getTag() {
        return this.tag;
    }

    @JsonProperty(value="tag")
    public void setTag(TagReference tag) {
        this.tag = tag;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "ImageStreamTag(apiVersion=" + this.getApiVersion() + ", conditions=" + this.getConditions() + ", generation=" + this.getGeneration() + ", image=" + this.getImage() + ", kind=" + this.getKind() + ", lookupPolicy=" + this.getLookupPolicy() + ", metadata=" + this.getMetadata() + ", tag=" + this.getTag() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageStreamTag)) {
            return false;
        }
        ImageStreamTag other = (ImageStreamTag)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        List<TagEventCondition> this$conditions = this.getConditions();
        List<TagEventCondition> other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !((Object)this$conditions).equals(other$conditions)) {
            return false;
        }
        Long this$generation = this.getGeneration();
        Long other$generation = other.getGeneration();
        if (this$generation == null ? other$generation != null : !((Object)this$generation).equals(other$generation)) {
            return false;
        }
        Image this$image = this.getImage();
        Image other$image = other.getImage();
        if (this$image == null ? other$image != null : !((Object)this$image).equals(other$image)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ImageLookupPolicy this$lookupPolicy = this.getLookupPolicy();
        ImageLookupPolicy other$lookupPolicy = other.getLookupPolicy();
        if (this$lookupPolicy == null ? other$lookupPolicy != null : !((Object)this$lookupPolicy).equals(other$lookupPolicy)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        TagReference this$tag = this.getTag();
        TagReference other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !((Object)this$tag).equals(other$tag)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ImageStreamTag;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        List<TagEventCondition> $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : ((Object)$conditions).hashCode());
        Long $generation = this.getGeneration();
        result = result * 59 + ($generation == null ? 43 : ((Object)$generation).hashCode());
        Image $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : ((Object)$image).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        ImageLookupPolicy $lookupPolicy = this.getLookupPolicy();
        result = result * 59 + ($lookupPolicy == null ? 43 : ((Object)$lookupPolicy).hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        TagReference $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : ((Object)$tag).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

