/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v4_0.utils;

import io.fabric8.kubernetes.clnt.v4_0.Config;
import io.fabric8.kubernetes.clnt.v4_0.RequestConfig;
import io.fabric8.kubernetes.clnt.v4_0.utils.Utils;
import java.io.IOException;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ImpersonatorInterceptor
implements Interceptor {
    private final Config config;

    public ImpersonatorInterceptor(Config config) {
        this.config = config;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestConfig requestConfig = this.config.getRequestConfig();
        if (Utils.isNotNullOrEmpty(requestConfig.getImpersonateUsername())) {
            Request.Builder requestBuilder = chain.request().newBuilder();
            requestBuilder.addHeader("Impersonate-User", requestConfig.getImpersonateUsername());
            for (String group : requestConfig.getImpersonateGroups()) {
                requestBuilder.addHeader("Impersonate-Group", group);
            }
            if (Utils.isNotNullOrEmpty(requestConfig.getImpersonateExtras())) {
                for (Map.Entry entry : requestConfig.getImpersonateExtras().entrySet()) {
                    requestBuilder.addHeader("Impersonate-Extra-" + (String)entry.getKey(), (String)entry.getValue());
                }
            }
            request = requestBuilder.build();
        }
        return chain.proceed(request);
    }
}

