/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_0.rbac;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Nested;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import io.fabric8.kubernetes.api.model.v4_0.ObjectMeta;
import io.fabric8.kubernetes.api.model.v4_0.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v4_0.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v4_0.rbac.KubernetesAggregationRule;
import io.fabric8.kubernetes.api.model.v4_0.rbac.KubernetesAggregationRuleBuilder;
import io.fabric8.kubernetes.api.model.v4_0.rbac.KubernetesAggregationRuleFluentImpl;
import io.fabric8.kubernetes.api.model.v4_0.rbac.KubernetesClusterRole;
import io.fabric8.kubernetes.api.model.v4_0.rbac.KubernetesClusterRoleFluent;
import io.fabric8.kubernetes.api.model.v4_0.rbac.KubernetesPolicyRule;
import io.fabric8.kubernetes.api.model.v4_0.rbac.KubernetesPolicyRuleBuilder;
import io.fabric8.kubernetes.api.model.v4_0.rbac.KubernetesPolicyRuleFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KubernetesClusterRoleFluentImpl<A extends KubernetesClusterRoleFluent<A>>
extends BaseFluent<A>
implements KubernetesClusterRoleFluent<A> {
    private KubernetesAggregationRuleBuilder aggregationRule;
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<KubernetesPolicyRuleBuilder> rules = new ArrayList<KubernetesPolicyRuleBuilder>();

    public KubernetesClusterRoleFluentImpl() {
    }

    public KubernetesClusterRoleFluentImpl(KubernetesClusterRole instance) {
        this.withAggregationRule(instance.getAggregationRule());
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRules(instance.getRules());
    }

    @Override
    @Deprecated
    public KubernetesAggregationRule getAggregationRule() {
        return this.aggregationRule != null ? this.aggregationRule.build() : null;
    }

    @Override
    public KubernetesAggregationRule buildAggregationRule() {
        return this.aggregationRule != null ? this.aggregationRule.build() : null;
    }

    @Override
    public A withAggregationRule(KubernetesAggregationRule aggregationRule) {
        this._visitables.remove(this.aggregationRule);
        if (aggregationRule != null) {
            this.aggregationRule = new KubernetesAggregationRuleBuilder(aggregationRule);
            this._visitables.add(this.aggregationRule);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAggregationRule() {
        return this.aggregationRule != null;
    }

    @Override
    public KubernetesClusterRoleFluent.AggregationRuleNested<A> withNewAggregationRule() {
        return new AggregationRuleNestedImpl();
    }

    @Override
    public KubernetesClusterRoleFluent.AggregationRuleNested<A> withNewAggregationRuleLike(KubernetesAggregationRule item) {
        return new AggregationRuleNestedImpl(item);
    }

    @Override
    public KubernetesClusterRoleFluent.AggregationRuleNested<A> editAggregationRule() {
        return this.withNewAggregationRuleLike(this.getAggregationRule());
    }

    @Override
    public KubernetesClusterRoleFluent.AggregationRuleNested<A> editOrNewAggregationRule() {
        return this.withNewAggregationRuleLike(this.getAggregationRule() != null ? this.getAggregationRule() : new KubernetesAggregationRuleBuilder().build());
    }

    @Override
    public KubernetesClusterRoleFluent.AggregationRuleNested<A> editOrNewAggregationRuleLike(KubernetesAggregationRule item) {
        return this.withNewAggregationRuleLike(this.getAggregationRule() != null ? this.getAggregationRule() : item);
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public KubernetesClusterRoleFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public KubernetesClusterRoleFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public KubernetesClusterRoleFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public KubernetesClusterRoleFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public KubernetesClusterRoleFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRules(int index, KubernetesPolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<KubernetesPolicyRuleBuilder>();
        }
        KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.rules.add(index >= 0 ? index : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(int index, KubernetesPolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<KubernetesPolicyRuleBuilder>();
        }
        KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(KubernetesPolicyRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<KubernetesPolicyRuleBuilder>();
        }
        for (KubernetesPolicyRule item : items) {
            KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<KubernetesPolicyRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<KubernetesPolicyRuleBuilder>();
        }
        for (KubernetesPolicyRule item : items) {
            KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(KubernetesPolicyRule ... items) {
        for (KubernetesPolicyRule item : items) {
            KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
            this._visitables.remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<KubernetesPolicyRule> items) {
        for (KubernetesPolicyRule item : items) {
            KubernetesPolicyRuleBuilder builder = new KubernetesPolicyRuleBuilder(item);
            this._visitables.remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KubernetesPolicyRule> getRules() {
        return KubernetesClusterRoleFluentImpl.build(this.rules);
    }

    @Override
    public List<KubernetesPolicyRule> buildRules() {
        return KubernetesClusterRoleFluentImpl.build(this.rules);
    }

    @Override
    public KubernetesPolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public KubernetesPolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public KubernetesPolicyRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public KubernetesPolicyRule buildMatchingRule(Predicate<KubernetesPolicyRuleBuilder> predicate) {
        for (KubernetesPolicyRuleBuilder item : this.rules) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withRules(List<KubernetesPolicyRule> rules) {
        if (this.rules == null) {
            this.rules = new ArrayList<KubernetesPolicyRuleBuilder>();
        } else {
            this._visitables.removeAll(this.rules);
            this.rules.clear();
        }
        if (rules != null) {
            for (KubernetesPolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRules(KubernetesPolicyRule ... rules) {
        this.rules.clear();
        if (rules != null) {
            for (KubernetesPolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public KubernetesClusterRoleFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public KubernetesClusterRoleFluent.RulesNested<A> addNewRuleLike(KubernetesPolicyRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public KubernetesClusterRoleFluent.RulesNested<A> setNewRuleLike(int index, KubernetesPolicyRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public KubernetesClusterRoleFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public KubernetesClusterRoleFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public KubernetesClusterRoleFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public KubernetesClusterRoleFluent.RulesNested<A> editMatchingRule(Predicate<KubernetesPolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.apply(this.rules.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesClusterRoleFluentImpl that = (KubernetesClusterRoleFluentImpl)o;
        if (this.aggregationRule != null ? !this.aggregationRule.equals(that.aggregationRule) : that.aggregationRule != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public class RulesNestedImpl<N>
    extends KubernetesPolicyRuleFluentImpl<KubernetesClusterRoleFluent.RulesNested<N>>
    implements KubernetesClusterRoleFluent.RulesNested<N>,
    Nested<N> {
        private final KubernetesPolicyRuleBuilder builder;
        private final int index;

        RulesNestedImpl(int index, KubernetesPolicyRule item) {
            this.index = index;
            this.builder = new KubernetesPolicyRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new KubernetesPolicyRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubernetesClusterRoleFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<KubernetesClusterRoleFluent.MetadataNested<N>>
    implements KubernetesClusterRoleFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubernetesClusterRoleFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class AggregationRuleNestedImpl<N>
    extends KubernetesAggregationRuleFluentImpl<KubernetesClusterRoleFluent.AggregationRuleNested<N>>
    implements KubernetesClusterRoleFluent.AggregationRuleNested<N>,
    Nested<N> {
        private final KubernetesAggregationRuleBuilder builder;

        AggregationRuleNestedImpl(KubernetesAggregationRule item) {
            this.builder = new KubernetesAggregationRuleBuilder(this, item);
        }

        AggregationRuleNestedImpl() {
            this.builder = new KubernetesAggregationRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubernetesClusterRoleFluentImpl.this.withAggregationRule(this.builder.build());
        }

        @Override
        public N endAggregationRule() {
            return this.and();
        }
    }
}

