/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v4_0;

import io.fabric8.kubernetes.api.builder.v4_0.BaseFluent;
import io.fabric8.kubernetes.api.builder.v4_0.Predicate;
import io.fabric8.kubernetes.api.model.v4_0.Quantity;
import io.fabric8.kubernetes.api.model.v4_0.ResourceQuotaSpec;
import io.fabric8.kubernetes.api.model.v4_0.ResourceQuotaSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ResourceQuotaSpecFluentImpl<A extends ResourceQuotaSpecFluent<A>>
extends BaseFluent<A>
implements ResourceQuotaSpecFluent<A> {
    private Map<String, Quantity> hard;
    private List<String> scopes;

    public ResourceQuotaSpecFluentImpl() {
    }

    public ResourceQuotaSpecFluentImpl(ResourceQuotaSpec instance) {
        this.withHard(instance.getHard());
        this.withScopes(instance.getScopes());
    }

    @Override
    public A addToHard(String key, Quantity value) {
        if (key != null && value != null) {
            this.hard.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToHard(Map<String, Quantity> map) {
        if (map != null) {
            this.hard.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromHard(String key) {
        if (key != null && this.hard != null) {
            this.hard.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromHard(Map<String, Quantity> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.hard == null) continue;
                this.hard.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getHard() {
        return this.hard;
    }

    @Override
    public A withHard(Map<String, Quantity> hard) {
        if (this.hard == null) {
            this.hard = new LinkedHashMap<String, Quantity>();
        } else {
            this.hard.clear();
        }
        if (hard != null) {
            this.hard.putAll(hard);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHard() {
        return this.hard != null;
    }

    @Override
    public A addToScopes(int index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToScopes(int index, String item) {
        this.scopes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToScopes(String ... items) {
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToScopes(Collection<String> items) {
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromScopes(String ... items) {
        for (String item : items) {
            if (this.scopes == null) continue;
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromScopes(Collection<String> items) {
        for (String item : items) {
            if (this.scopes == null) continue;
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public String getScope(int index) {
        return this.scopes.get(index);
    }

    @Override
    public String getFirstScope() {
        return this.scopes.get(0);
    }

    @Override
    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    @Override
    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withScopes(List<String> scopes) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        } else {
            this._visitables.removeAll(this.scopes);
            this.scopes.clear();
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withScopes(String ... scopes) {
        this.scopes.clear();
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceQuotaSpecFluentImpl that = (ResourceQuotaSpecFluentImpl)o;
        if (this.hard != null ? !this.hard.equals(that.hard) : that.hard != null) {
            return false;
        }
        return !(this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null);
    }
}

