/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v3_2;

import io.fabric8.kubernetes.api.builder.v3_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_2.VisitableBuilder;
import io.fabric8.openshift.api.model.v3_2.SecretSpec;
import io.fabric8.openshift.api.model.v3_2.SecretSpecFluent;
import io.fabric8.openshift.api.model.v3_2.SecretSpecFluentImpl;

public class SecretSpecBuilder
extends SecretSpecFluentImpl<SecretSpecBuilder>
implements VisitableBuilder<SecretSpec, SecretSpecBuilder> {
    SecretSpecFluent<?> fluent;
    Boolean validationEnabled;

    public SecretSpecBuilder() {
        this(true);
    }

    public SecretSpecBuilder(Boolean validationEnabled) {
        this(new SecretSpec(), validationEnabled);
    }

    public SecretSpecBuilder(SecretSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SecretSpecBuilder(SecretSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new SecretSpec(), validationEnabled);
    }

    public SecretSpecBuilder(SecretSpecFluent<?> fluent, SecretSpec instance) {
        this(fluent, instance, true);
    }

    public SecretSpecBuilder(SecretSpecFluent<?> fluent, SecretSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMountPath(instance.getMountPath());
        fluent.withSecretSource(instance.getSecretSource());
        this.validationEnabled = validationEnabled;
    }

    public SecretSpecBuilder(SecretSpec instance) {
        this(instance, (Boolean)true);
    }

    public SecretSpecBuilder(SecretSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMountPath(instance.getMountPath());
        this.withSecretSource(instance.getSecretSource());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public SecretSpec build() {
        SecretSpec buildable = new SecretSpec(this.fluent.getMountPath(), this.fluent.getSecretSource());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretSpecBuilder that = (SecretSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

