/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v3_2;

import io.fabric8.kubernetes.api.builder.v3_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_2.Nested;
import io.fabric8.kubernetes.api.builder.v3_2.Predicate;
import io.fabric8.kubernetes.api.model.v3_2.ObjectMeta;
import io.fabric8.kubernetes.api.model.v3_2.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v3_2.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v3_2.OAuthClient;
import io.fabric8.openshift.api.model.v3_2.OAuthClientFluent;
import io.fabric8.openshift.api.model.v3_2.ScopeRestriction;
import io.fabric8.openshift.api.model.v3_2.ScopeRestrictionBuilder;
import io.fabric8.openshift.api.model.v3_2.ScopeRestrictionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OAuthClientFluentImpl<A extends OAuthClientFluent<A>>
extends BaseFluent<A>
implements OAuthClientFluent<A> {
    private List<String> additionalSecrets = new ArrayList<String>();
    private String apiVersion;
    private String grantMethod;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<String> redirectURIs = new ArrayList<String>();
    private Boolean respondWithChallenges;
    private List<ScopeRestrictionBuilder> scopeRestrictions = new ArrayList<ScopeRestrictionBuilder>();
    private String secret;

    public OAuthClientFluentImpl() {
    }

    public OAuthClientFluentImpl(OAuthClient instance) {
        this.withAdditionalSecrets(instance.getAdditionalSecrets());
        this.withApiVersion(instance.getApiVersion());
        this.withGrantMethod(instance.getGrantMethod());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRedirectURIs(instance.getRedirectURIs());
        this.withRespondWithChallenges(instance.getRespondWithChallenges());
        this.withScopeRestrictions(instance.getScopeRestrictions());
        this.withSecret(instance.getSecret());
    }

    @Override
    public A addToAdditionalSecrets(int index, String item) {
        this.additionalSecrets.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdditionalSecrets(int index, String item) {
        this.additionalSecrets.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdditionalSecrets(String ... items) {
        for (String item : items) {
            this.additionalSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdditionalSecrets(Collection<String> items) {
        for (String item : items) {
            this.additionalSecrets.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalSecrets(String ... items) {
        for (String item : items) {
            this.additionalSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdditionalSecrets(Collection<String> items) {
        for (String item : items) {
            this.additionalSecrets.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAdditionalSecrets() {
        return this.additionalSecrets;
    }

    @Override
    public String getAdditionalSecret(int index) {
        return this.additionalSecrets.get(index);
    }

    @Override
    public String getFirstAdditionalSecret() {
        return this.additionalSecrets.get(0);
    }

    @Override
    public String getLastAdditionalSecret() {
        return this.additionalSecrets.get(this.additionalSecrets.size() - 1);
    }

    @Override
    public String getMatchingAdditionalSecret(Predicate<String> predicate) {
        for (String item : this.additionalSecrets) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withAdditionalSecrets(List<String> additionalSecrets) {
        this.additionalSecrets.clear();
        if (additionalSecrets != null) {
            for (String item : additionalSecrets) {
                this.addToAdditionalSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAdditionalSecrets(String ... additionalSecrets) {
        this.additionalSecrets.clear();
        if (additionalSecrets != null) {
            for (String item : additionalSecrets) {
                this.addToAdditionalSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalSecrets() {
        return this.additionalSecrets != null && !this.additionalSecrets.isEmpty();
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getGrantMethod() {
        return this.grantMethod;
    }

    @Override
    public A withGrantMethod(String grantMethod) {
        this.grantMethod = grantMethod;
        return (A)this;
    }

    @Override
    public Boolean hasGrantMethod() {
        return this.grantMethod != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public OAuthClientFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToRedirectURIs(int index, String item) {
        this.redirectURIs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRedirectURIs(int index, String item) {
        this.redirectURIs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRedirectURIs(String ... items) {
        for (String item : items) {
            this.redirectURIs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRedirectURIs(Collection<String> items) {
        for (String item : items) {
            this.redirectURIs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRedirectURIs(String ... items) {
        for (String item : items) {
            this.redirectURIs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRedirectURIs(Collection<String> items) {
        for (String item : items) {
            this.redirectURIs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRedirectURIs() {
        return this.redirectURIs;
    }

    @Override
    public String getRedirectURI(int index) {
        return this.redirectURIs.get(index);
    }

    @Override
    public String getFirstRedirectURI() {
        return this.redirectURIs.get(0);
    }

    @Override
    public String getLastRedirectURI() {
        return this.redirectURIs.get(this.redirectURIs.size() - 1);
    }

    @Override
    public String getMatchingRedirectURI(Predicate<String> predicate) {
        for (String item : this.redirectURIs) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withRedirectURIs(List<String> redirectURIs) {
        this.redirectURIs.clear();
        if (redirectURIs != null) {
            for (String item : redirectURIs) {
                this.addToRedirectURIs(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRedirectURIs(String ... redirectURIs) {
        this.redirectURIs.clear();
        if (redirectURIs != null) {
            for (String item : redirectURIs) {
                this.addToRedirectURIs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRedirectURIs() {
        return this.redirectURIs != null && !this.redirectURIs.isEmpty();
    }

    @Override
    public Boolean isRespondWithChallenges() {
        return this.respondWithChallenges;
    }

    @Override
    public A withRespondWithChallenges(Boolean respondWithChallenges) {
        this.respondWithChallenges = respondWithChallenges;
        return (A)this;
    }

    @Override
    public Boolean hasRespondWithChallenges() {
        return this.respondWithChallenges != null;
    }

    @Override
    public A addToScopeRestrictions(int index, ScopeRestriction item) {
        ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.scopeRestrictions.add(index >= 0 ? index : this.scopeRestrictions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToScopeRestrictions(int index, ScopeRestriction item) {
        ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.scopeRestrictions.size()) {
            this.scopeRestrictions.add(builder);
        } else {
            this.scopeRestrictions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToScopeRestrictions(ScopeRestriction ... items) {
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.add(builder);
            this.scopeRestrictions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToScopeRestrictions(Collection<ScopeRestriction> items) {
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.add(builder);
            this.scopeRestrictions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromScopeRestrictions(ScopeRestriction ... items) {
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.remove(builder);
            this.scopeRestrictions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromScopeRestrictions(Collection<ScopeRestriction> items) {
        for (ScopeRestriction item : items) {
            ScopeRestrictionBuilder builder = new ScopeRestrictionBuilder(item);
            this._visitables.remove(builder);
            this.scopeRestrictions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ScopeRestriction> getScopeRestrictions() {
        return OAuthClientFluentImpl.build(this.scopeRestrictions);
    }

    @Override
    public List<ScopeRestriction> buildScopeRestrictions() {
        return OAuthClientFluentImpl.build(this.scopeRestrictions);
    }

    @Override
    public ScopeRestriction buildScopeRestriction(int index) {
        return this.scopeRestrictions.get(index).build();
    }

    @Override
    public ScopeRestriction buildFirstScopeRestriction() {
        return this.scopeRestrictions.get(0).build();
    }

    @Override
    public ScopeRestriction buildLastScopeRestriction() {
        return this.scopeRestrictions.get(this.scopeRestrictions.size() - 1).build();
    }

    @Override
    public ScopeRestriction buildMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
        for (ScopeRestrictionBuilder item : this.scopeRestrictions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withScopeRestrictions(List<ScopeRestriction> scopeRestrictions) {
        this._visitables.removeAll(this.scopeRestrictions);
        this.scopeRestrictions.clear();
        if (scopeRestrictions != null) {
            for (ScopeRestriction item : scopeRestrictions) {
                this.addToScopeRestrictions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withScopeRestrictions(ScopeRestriction ... scopeRestrictions) {
        this.scopeRestrictions.clear();
        if (scopeRestrictions != null) {
            for (ScopeRestriction item : scopeRestrictions) {
                this.addToScopeRestrictions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasScopeRestrictions() {
        return this.scopeRestrictions != null && !this.scopeRestrictions.isEmpty();
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestriction() {
        return new ScopeRestrictionsNestedImpl();
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> addNewScopeRestrictionLike(ScopeRestriction item) {
        return new ScopeRestrictionsNestedImpl(-1, item);
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> setNewScopeRestrictionLike(int index, ScopeRestriction item) {
        return new ScopeRestrictionsNestedImpl(index, item);
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editScopeRestriction(int index) {
        if (this.scopeRestrictions.size() <= index) {
            throw new RuntimeException("Can't edit scopeRestrictions. Index exceeds size.");
        }
        return this.setNewScopeRestrictionLike(index, this.buildScopeRestriction(index));
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editFirstScopeRestriction() {
        if (this.scopeRestrictions.size() == 0) {
            throw new RuntimeException("Can't edit first scopeRestrictions. The list is empty.");
        }
        return this.setNewScopeRestrictionLike(0, this.buildScopeRestriction(0));
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editLastScopeRestriction() {
        int index = this.scopeRestrictions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last scopeRestrictions. The list is empty.");
        }
        return this.setNewScopeRestrictionLike(index, this.buildScopeRestriction(index));
    }

    @Override
    public OAuthClientFluent.ScopeRestrictionsNested<A> editMatchingScopeRestriction(Predicate<ScopeRestrictionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.scopeRestrictions.size(); ++i) {
            if (!predicate.apply(this.scopeRestrictions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching scopeRestrictions. No match found.");
        }
        return this.setNewScopeRestrictionLike(index, this.buildScopeRestriction(index));
    }

    @Override
    public String getSecret() {
        return this.secret;
    }

    @Override
    public A withSecret(String secret) {
        this.secret = secret;
        return (A)this;
    }

    @Override
    public Boolean hasSecret() {
        return this.secret != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthClientFluentImpl that = (OAuthClientFluentImpl)o;
        if (this.additionalSecrets != null ? !this.additionalSecrets.equals(that.additionalSecrets) : that.additionalSecrets != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.grantMethod != null ? !this.grantMethod.equals(that.grantMethod) : that.grantMethod != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.redirectURIs != null ? !this.redirectURIs.equals(that.redirectURIs) : that.redirectURIs != null) {
            return false;
        }
        if (this.respondWithChallenges != null ? !this.respondWithChallenges.equals(that.respondWithChallenges) : that.respondWithChallenges != null) {
            return false;
        }
        if (this.scopeRestrictions != null ? !this.scopeRestrictions.equals(that.scopeRestrictions) : that.scopeRestrictions != null) {
            return false;
        }
        return !(this.secret != null ? !this.secret.equals(that.secret) : that.secret != null);
    }

    public class ScopeRestrictionsNestedImpl<N>
    extends ScopeRestrictionFluentImpl<OAuthClientFluent.ScopeRestrictionsNested<N>>
    implements OAuthClientFluent.ScopeRestrictionsNested<N>,
    Nested<N> {
        private final ScopeRestrictionBuilder builder;
        private final int index;

        ScopeRestrictionsNestedImpl(int index, ScopeRestriction item) {
            this.index = index;
            this.builder = new ScopeRestrictionBuilder(this, item);
        }

        ScopeRestrictionsNestedImpl() {
            this.index = -1;
            this.builder = new ScopeRestrictionBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthClientFluentImpl.this.setToScopeRestrictions(this.index, this.builder.build());
        }

        @Override
        public N endScopeRestriction() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<OAuthClientFluent.MetadataNested<N>>
    implements OAuthClientFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthClientFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

