/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v3_2;

import io.fabric8.kubernetes.api.builder.v3_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_2.Nested;
import io.fabric8.kubernetes.api.model.v3_2.ObjectMeta;
import io.fabric8.kubernetes.api.model.v3_2.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v3_2.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v3_2.DeploymentConfig;
import io.fabric8.openshift.api.model.v3_2.DeploymentConfigFluent;
import io.fabric8.openshift.api.model.v3_2.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.v3_2.DeploymentConfigSpecBuilder;
import io.fabric8.openshift.api.model.v3_2.DeploymentConfigSpecFluentImpl;
import io.fabric8.openshift.api.model.v3_2.DeploymentConfigStatus;
import io.fabric8.openshift.api.model.v3_2.DeploymentConfigStatusBuilder;
import io.fabric8.openshift.api.model.v3_2.DeploymentConfigStatusFluentImpl;

public class DeploymentConfigFluentImpl<A extends DeploymentConfigFluent<A>>
extends BaseFluent<A>
implements DeploymentConfigFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private DeploymentConfigSpecBuilder spec;
    private DeploymentConfigStatusBuilder status;

    public DeploymentConfigFluentImpl() {
    }

    public DeploymentConfigFluentImpl(DeploymentConfig instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public DeploymentConfigFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public DeploymentConfigFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public DeploymentConfigFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public DeploymentConfigFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public DeploymentConfigFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public DeploymentConfigSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public DeploymentConfigSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(DeploymentConfigSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new DeploymentConfigSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public DeploymentConfigFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public DeploymentConfigFluent.SpecNested<A> withNewSpecLike(DeploymentConfigSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public DeploymentConfigFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public DeploymentConfigFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new DeploymentConfigSpecBuilder().build());
    }

    @Override
    public DeploymentConfigFluent.SpecNested<A> editOrNewSpecLike(DeploymentConfigSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public DeploymentConfigStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public DeploymentConfigStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(DeploymentConfigStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new DeploymentConfigStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public DeploymentConfigFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public DeploymentConfigFluent.StatusNested<A> withNewStatusLike(DeploymentConfigStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public DeploymentConfigFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public DeploymentConfigFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new DeploymentConfigStatusBuilder().build());
    }

    @Override
    public DeploymentConfigFluent.StatusNested<A> editOrNewStatusLike(DeploymentConfigStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeploymentConfigFluentImpl that = (DeploymentConfigFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends DeploymentConfigStatusFluentImpl<DeploymentConfigFluent.StatusNested<N>>
    implements DeploymentConfigFluent.StatusNested<N>,
    Nested<N> {
        private final DeploymentConfigStatusBuilder builder;

        StatusNestedImpl(DeploymentConfigStatus item) {
            this.builder = new DeploymentConfigStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new DeploymentConfigStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends DeploymentConfigSpecFluentImpl<DeploymentConfigFluent.SpecNested<N>>
    implements DeploymentConfigFluent.SpecNested<N>,
    Nested<N> {
        private final DeploymentConfigSpecBuilder builder;

        SpecNestedImpl(DeploymentConfigSpec item) {
            this.builder = new DeploymentConfigSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new DeploymentConfigSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<DeploymentConfigFluent.MetadataNested<N>>
    implements DeploymentConfigFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

