/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v3_2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.v3_2.EnvVar;
import io.fabric8.kubernetes.api.model.v3_2.HasMetadata;
import io.fabric8.kubernetes.api.model.v3_2.ObjectMeta;
import io.fabric8.kubernetes.api.model.v3_2.ObjectReference;
import io.fabric8.kubernetes.api.model.v3_2.validators.CheckObjectMeta;
import io.fabric8.openshift.api.model.v3_2.BinaryBuildSource;
import io.fabric8.openshift.api.model.v3_2.BuildTriggerCause;
import io.fabric8.openshift.api.model.v3_2.DockerStrategyOptions;
import io.fabric8.openshift.api.model.v3_2.SourceRevision;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "binary", "dockerStrategyOptions", "env", "from", "lastVersion", "revision", "triggeredBy", "triggeredByImage"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class BuildRequest
implements HasMetadata {
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "build.openshift.io/v1";
    @JsonProperty(value="binary")
    @Valid
    private BinaryBuildSource binary;
    @JsonProperty(value="dockerStrategyOptions")
    @Valid
    private DockerStrategyOptions dockerStrategyOptions;
    @JsonProperty(value="env")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Valid
    private List<EnvVar> env = new ArrayList<EnvVar>();
    @JsonProperty(value="from")
    @Valid
    private ObjectReference from;
    @NotNull
    @JsonProperty(value="kind")
    private String kind = "BuildRequest";
    @JsonProperty(value="lastVersion")
    private Long lastVersion;
    @JsonProperty(value="metadata")
    @Valid
    @CheckObjectMeta(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$", max=253)
    private ObjectMeta metadata;
    @JsonProperty(value="revision")
    @Valid
    private SourceRevision revision;
    @JsonProperty(value="triggeredBy")
    @Valid
    private List<BuildTriggerCause> triggeredBy = new ArrayList<BuildTriggerCause>();
    @JsonProperty(value="triggeredByImage")
    @Valid
    private ObjectReference triggeredByImage;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildRequest() {
    }

    public BuildRequest(String apiVersion, BinaryBuildSource binary, DockerStrategyOptions dockerStrategyOptions, List<EnvVar> env, ObjectReference from, String kind, Long lastVersion, ObjectMeta metadata, SourceRevision revision, List<BuildTriggerCause> triggeredBy, ObjectReference triggeredByImage) {
        this.apiVersion = apiVersion;
        this.binary = binary;
        this.dockerStrategyOptions = dockerStrategyOptions;
        this.env = env;
        this.from = from;
        this.kind = kind;
        this.lastVersion = lastVersion;
        this.metadata = metadata;
        this.revision = revision;
        this.triggeredBy = triggeredBy;
        this.triggeredByImage = triggeredByImage;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="binary")
    public BinaryBuildSource getBinary() {
        return this.binary;
    }

    @JsonProperty(value="binary")
    public void setBinary(BinaryBuildSource binary) {
        this.binary = binary;
    }

    @JsonProperty(value="dockerStrategyOptions")
    public DockerStrategyOptions getDockerStrategyOptions() {
        return this.dockerStrategyOptions;
    }

    @JsonProperty(value="dockerStrategyOptions")
    public void setDockerStrategyOptions(DockerStrategyOptions dockerStrategyOptions) {
        this.dockerStrategyOptions = dockerStrategyOptions;
    }

    @JsonProperty(value="env")
    public List<EnvVar> getEnv() {
        return this.env;
    }

    @JsonProperty(value="env")
    public void setEnv(List<EnvVar> env) {
        this.env = env;
    }

    @JsonProperty(value="from")
    public ObjectReference getFrom() {
        return this.from;
    }

    @JsonProperty(value="from")
    public void setFrom(ObjectReference from) {
        this.from = from;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @JsonProperty(value="lastVersion")
    public Long getLastVersion() {
        return this.lastVersion;
    }

    @JsonProperty(value="lastVersion")
    public void setLastVersion(Long lastVersion) {
        this.lastVersion = lastVersion;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="revision")
    public SourceRevision getRevision() {
        return this.revision;
    }

    @JsonProperty(value="revision")
    public void setRevision(SourceRevision revision) {
        this.revision = revision;
    }

    @JsonProperty(value="triggeredBy")
    public List<BuildTriggerCause> getTriggeredBy() {
        return this.triggeredBy;
    }

    @JsonProperty(value="triggeredBy")
    public void setTriggeredBy(List<BuildTriggerCause> triggeredBy) {
        this.triggeredBy = triggeredBy;
    }

    @JsonProperty(value="triggeredByImage")
    public ObjectReference getTriggeredByImage() {
        return this.triggeredByImage;
    }

    @JsonProperty(value="triggeredByImage")
    public void setTriggeredByImage(ObjectReference triggeredByImage) {
        this.triggeredByImage = triggeredByImage;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "BuildRequest(apiVersion=" + this.getApiVersion() + ", binary=" + this.getBinary() + ", dockerStrategyOptions=" + this.getDockerStrategyOptions() + ", env=" + this.getEnv() + ", from=" + this.getFrom() + ", kind=" + this.getKind() + ", lastVersion=" + this.getLastVersion() + ", metadata=" + this.getMetadata() + ", revision=" + this.getRevision() + ", triggeredBy=" + this.getTriggeredBy() + ", triggeredByImage=" + this.getTriggeredByImage() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildRequest)) {
            return false;
        }
        BuildRequest other = (BuildRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        BinaryBuildSource this$binary = this.getBinary();
        BinaryBuildSource other$binary = other.getBinary();
        if (this$binary == null ? other$binary != null : !((Object)this$binary).equals(other$binary)) {
            return false;
        }
        DockerStrategyOptions this$dockerStrategyOptions = this.getDockerStrategyOptions();
        DockerStrategyOptions other$dockerStrategyOptions = other.getDockerStrategyOptions();
        if (this$dockerStrategyOptions == null ? other$dockerStrategyOptions != null : !((Object)this$dockerStrategyOptions).equals(other$dockerStrategyOptions)) {
            return false;
        }
        List<EnvVar> this$env = this.getEnv();
        List<EnvVar> other$env = other.getEnv();
        if (this$env == null ? other$env != null : !((Object)this$env).equals(other$env)) {
            return false;
        }
        ObjectReference this$from = this.getFrom();
        ObjectReference other$from = other.getFrom();
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        Long this$lastVersion = this.getLastVersion();
        Long other$lastVersion = other.getLastVersion();
        if (this$lastVersion == null ? other$lastVersion != null : !((Object)this$lastVersion).equals(other$lastVersion)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        SourceRevision this$revision = this.getRevision();
        SourceRevision other$revision = other.getRevision();
        if (this$revision == null ? other$revision != null : !((Object)this$revision).equals(other$revision)) {
            return false;
        }
        List<BuildTriggerCause> this$triggeredBy = this.getTriggeredBy();
        List<BuildTriggerCause> other$triggeredBy = other.getTriggeredBy();
        if (this$triggeredBy == null ? other$triggeredBy != null : !((Object)this$triggeredBy).equals(other$triggeredBy)) {
            return false;
        }
        ObjectReference this$triggeredByImage = this.getTriggeredByImage();
        ObjectReference other$triggeredByImage = other.getTriggeredByImage();
        if (this$triggeredByImage == null ? other$triggeredByImage != null : !((Object)this$triggeredByImage).equals(other$triggeredByImage)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        BinaryBuildSource $binary = this.getBinary();
        result = result * 59 + ($binary == null ? 43 : ((Object)$binary).hashCode());
        DockerStrategyOptions $dockerStrategyOptions = this.getDockerStrategyOptions();
        result = result * 59 + ($dockerStrategyOptions == null ? 43 : ((Object)$dockerStrategyOptions).hashCode());
        List<EnvVar> $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : ((Object)$env).hashCode());
        ObjectReference $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        Long $lastVersion = this.getLastVersion();
        result = result * 59 + ($lastVersion == null ? 43 : ((Object)$lastVersion).hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        SourceRevision $revision = this.getRevision();
        result = result * 59 + ($revision == null ? 43 : ((Object)$revision).hashCode());
        List<BuildTriggerCause> $triggeredBy = this.getTriggeredBy();
        result = result * 59 + ($triggeredBy == null ? 43 : ((Object)$triggeredBy).hashCode());
        ObjectReference $triggeredByImage = this.getTriggeredByImage();
        result = result * 59 + ($triggeredByImage == null ? 43 : ((Object)$triggeredByImage).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

