/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v3_2.utils;

import io.fabric8.kubernetes.clnt.v3_2.Config;
import io.fabric8.kubernetes.clnt.v3_2.RequestConfig;
import io.fabric8.kubernetes.clnt.v3_2.utils.Utils;
import java.io.IOException;
import java.util.Map;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class ImpersonatorInterceptor
implements Interceptor {
    private final Config config;

    public ImpersonatorInterceptor(Config config) {
        this.config = config;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestConfig requestConfig = this.config.getRequestConfig();
        if (Utils.isNotNullOrEmpty(requestConfig.getImpersonateUsername())) {
            Request.Builder requestBuilder = chain.request().newBuilder();
            requestBuilder.addHeader("Impersonate-User", requestConfig.getImpersonateUsername());
            if (Utils.isNotNullOrEmpty(requestConfig.getImpersonateGroup())) {
                requestBuilder.addHeader("Impersonate-Group", requestConfig.getImpersonateGroup());
            }
            if (Utils.isNotNullOrEmpty(requestConfig.getImpersonateExtras())) {
                for (Map.Entry<String, String> entry : requestConfig.getImpersonateExtras().entrySet()) {
                    requestBuilder.addHeader("Impersonate-Extra-" + entry.getKey(), entry.getValue());
                }
            }
            request = requestBuilder.build();
        }
        return chain.proceed(request);
    }
}

