/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v3_2.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.KubernetesResourceMappingProvider;
import io.fabric8.kubernetes.api.model.v3_2.KubernetesResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class KubernetesDeserializer
extends JsonDeserializer<KubernetesResource> {
    private static final String KIND = "kind";
    private static final String API_VERSION = "apiVersion";
    private static final String KEY_SEPARATOR = "#";
    private static final String KUBERNETES_PACKAGE_PREFIX = "io.fabric8.kubernetes.api.model.v3_2.";
    private static final String KUBERNETES_EXTENSIONS_PACKAGE_PREFIX = "io.fabric8.kubernetes.api.model.v3_2.extensions.";
    private static final String KUBERNETES_APIEXTENSIONS_PACKAGE_PREFIX = "io.fabric8.kubernetes.api.model.v3_2.apiextensions.";
    private static final String OPENSHIFT_PACKAGE_PREFIX = "io.fabric8.openshift.api.model.v3_2.";
    private static final Map<String, Class<? extends KubernetesResource>> MAP = new HashMap<String, Class<? extends KubernetesResource>>();

    public KubernetesResource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ObjectNode node = (ObjectNode)jp.readValueAsTree();
        String key = KubernetesDeserializer.getKey(node);
        if (key != null) {
            Class resourceType = KubernetesDeserializer.getTypeForKey(key);
            if (resourceType == null) {
                throw ctxt.mappingException("No resource type found for:" + key);
            }
            return (KubernetesResource)jp.getCodec().treeToValue((TreeNode)node, resourceType);
        }
        return null;
    }

    private static final String getKey(ObjectNode node) {
        JsonNode apiVersion = node.get(API_VERSION);
        JsonNode kind = node.get(KIND);
        return KubernetesDeserializer.getKey(apiVersion != null ? apiVersion.textValue() : null, kind != null ? kind.textValue() : null);
    }

    private static final String getKey(String apiVersion, String kind) {
        if (kind == null) {
            return null;
        }
        if (apiVersion == null) {
            return kind;
        }
        return String.format("%s#%s", apiVersion, kind);
    }

    public static void registerCustomKind(String kind, Class<? extends KubernetesResource> clazz) {
        KubernetesDeserializer.registerCustomKind(null, kind, clazz);
    }

    public static void registerCustomKind(String apiVersion, String kind, Class<? extends KubernetesResource> clazz) {
        MAP.put(KubernetesDeserializer.getKey(apiVersion, kind), clazz);
    }

    static Class getTypeForKey(String key) {
        Class result = MAP.get(key);
        if (result == null) {
            String name = key != null && key.contains(KEY_SEPARATOR) ? key.substring(key.indexOf(KEY_SEPARATOR) + 1) : key;
            System.out.println("Trying internal type for name:" + name);
            result = KubernetesDeserializer.getInternalTypeForName(name);
        }
        if (result != null) {
            MAP.put(key, result);
        }
        return result;
    }

    private static Class getInternalTypeForName(String name) {
        Class result = KubernetesDeserializer.loadClassIfExists(KUBERNETES_PACKAGE_PREFIX + name);
        if (result == null && (result = KubernetesDeserializer.loadClassIfExists(KUBERNETES_EXTENSIONS_PACKAGE_PREFIX + name)) == null && (result = KubernetesDeserializer.loadClassIfExists(OPENSHIFT_PACKAGE_PREFIX + name)) == null) {
            result = KubernetesDeserializer.loadClassIfExists(KUBERNETES_APIEXTENSIONS_PACKAGE_PREFIX + name);
        }
        return result;
    }

    private static Class loadClassIfExists(String className) {
        try {
            return KubernetesDeserializer.class.getClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            return null;
        }
    }

    static {
        for (KubernetesResourceMappingProvider provider : ServiceLoader.load(KubernetesResourceMappingProvider.class)) {
            MAP.putAll(provider.getMappings());
        }
    }
}

