/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_2.extensions;

import io.fabric8.kubernetes.api.builder.v3_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_2.Nested;
import io.fabric8.kubernetes.api.builder.v3_2.Predicate;
import io.fabric8.kubernetes.api.model.v3_2.extensions.FSGroupStrategyOptions;
import io.fabric8.kubernetes.api.model.v3_2.extensions.FSGroupStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.v3_2.extensions.FSGroupStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.v3_2.extensions.HostPortRange;
import io.fabric8.kubernetes.api.model.v3_2.extensions.HostPortRangeBuilder;
import io.fabric8.kubernetes.api.model.v3_2.extensions.HostPortRangeFluentImpl;
import io.fabric8.kubernetes.api.model.v3_2.extensions.KubernetesRunAsUserStrategyOptions;
import io.fabric8.kubernetes.api.model.v3_2.extensions.KubernetesRunAsUserStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.v3_2.extensions.KubernetesRunAsUserStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.v3_2.extensions.PodSecurityPolicySpec;
import io.fabric8.kubernetes.api.model.v3_2.extensions.PodSecurityPolicySpecFluent;
import io.fabric8.kubernetes.api.model.v3_2.extensions.SELinuxStrategyOptions;
import io.fabric8.kubernetes.api.model.v3_2.extensions.SELinuxStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.v3_2.extensions.SELinuxStrategyOptionsFluentImpl;
import io.fabric8.kubernetes.api.model.v3_2.extensions.SupplementalGroupsStrategyOptions;
import io.fabric8.kubernetes.api.model.v3_2.extensions.SupplementalGroupsStrategyOptionsBuilder;
import io.fabric8.kubernetes.api.model.v3_2.extensions.SupplementalGroupsStrategyOptionsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PodSecurityPolicySpecFluentImpl<A extends PodSecurityPolicySpecFluent<A>>
extends BaseFluent<A>
implements PodSecurityPolicySpecFluent<A> {
    private List<String> allowedCapabilities = new ArrayList<String>();
    private List<String> defaultAddCapabilities = new ArrayList<String>();
    private FSGroupStrategyOptionsBuilder fsGroup;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private List<HostPortRangeBuilder> hostPorts = new ArrayList<HostPortRangeBuilder>();
    private Boolean privileged;
    private Boolean readOnlyRootFilesystem;
    private List<String> requiredDropCapabilities = new ArrayList<String>();
    private KubernetesRunAsUserStrategyOptionsBuilder runAsUser;
    private SELinuxStrategyOptionsBuilder seLinux;
    private SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
    private List<String> volumes = new ArrayList<String>();

    public PodSecurityPolicySpecFluentImpl() {
    }

    public PodSecurityPolicySpecFluentImpl(PodSecurityPolicySpec instance) {
        this.withAllowedCapabilities(instance.getAllowedCapabilities());
        this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities());
        this.withFsGroup(instance.getFsGroup());
        this.withHostIPC(instance.getHostIPC());
        this.withHostNetwork(instance.getHostNetwork());
        this.withHostPID(instance.getHostPID());
        this.withHostPorts(instance.getHostPorts());
        this.withPrivileged(instance.getPrivileged());
        this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem());
        this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinux(instance.getSeLinux());
        this.withSupplementalGroups(instance.getSupplementalGroups());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public A addToAllowedCapabilities(int index, String item) {
        this.allowedCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedCapabilities(int index, String item) {
        this.allowedCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedCapabilities(Collection<String> items) {
        for (String item : items) {
            this.allowedCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedCapabilities(String ... items) {
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedCapabilities(Collection<String> items) {
        for (String item : items) {
            this.allowedCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedCapabilities() {
        return this.allowedCapabilities;
    }

    @Override
    public String getAllowedCapability(int index) {
        return this.allowedCapabilities.get(index);
    }

    @Override
    public String getFirstAllowedCapability() {
        return this.allowedCapabilities.get(0);
    }

    @Override
    public String getLastAllowedCapability() {
        return this.allowedCapabilities.get(this.allowedCapabilities.size() - 1);
    }

    @Override
    public String getMatchingAllowedCapability(Predicate<String> predicate) {
        for (String item : this.allowedCapabilities) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withAllowedCapabilities(List<String> allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withAllowedCapabilities(String ... allowedCapabilities) {
        this.allowedCapabilities.clear();
        if (allowedCapabilities != null) {
            for (String item : allowedCapabilities) {
                this.addToAllowedCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedCapabilities() {
        return this.allowedCapabilities != null && !this.allowedCapabilities.isEmpty();
    }

    @Override
    public A addToDefaultAddCapabilities(int index, String item) {
        this.defaultAddCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDefaultAddCapabilities(int index, String item) {
        this.defaultAddCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDefaultAddCapabilities(Collection<String> items) {
        for (String item : items) {
            this.defaultAddCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDefaultAddCapabilities(String ... items) {
        for (String item : items) {
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDefaultAddCapabilities(Collection<String> items) {
        for (String item : items) {
            this.defaultAddCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDefaultAddCapabilities() {
        return this.defaultAddCapabilities;
    }

    @Override
    public String getDefaultAddCapability(int index) {
        return this.defaultAddCapabilities.get(index);
    }

    @Override
    public String getFirstDefaultAddCapability() {
        return this.defaultAddCapabilities.get(0);
    }

    @Override
    public String getLastDefaultAddCapability() {
        return this.defaultAddCapabilities.get(this.defaultAddCapabilities.size() - 1);
    }

    @Override
    public String getMatchingDefaultAddCapability(Predicate<String> predicate) {
        for (String item : this.defaultAddCapabilities) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities) {
        this.defaultAddCapabilities.clear();
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withDefaultAddCapabilities(String ... defaultAddCapabilities) {
        this.defaultAddCapabilities.clear();
        if (defaultAddCapabilities != null) {
            for (String item : defaultAddCapabilities) {
                this.addToDefaultAddCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultAddCapabilities() {
        return this.defaultAddCapabilities != null && !this.defaultAddCapabilities.isEmpty();
    }

    @Override
    @Deprecated
    public FSGroupStrategyOptions getFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    @Override
    public FSGroupStrategyOptions buildFsGroup() {
        return this.fsGroup != null ? this.fsGroup.build() : null;
    }

    @Override
    public A withFsGroup(FSGroupStrategyOptions fsGroup) {
        this._visitables.remove(this.fsGroup);
        if (fsGroup != null) {
            this.fsGroup = new FSGroupStrategyOptionsBuilder(fsGroup);
            this._visitables.add(this.fsGroup);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFsGroup() {
        return this.fsGroup != null;
    }

    @Override
    public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroup() {
        return new FsGroupNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item) {
        return new FsGroupNestedImpl(item);
    }

    @Override
    public PodSecurityPolicySpecFluent.FsGroupNested<A> editFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup());
    }

    @Override
    public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroup() {
        return this.withNewFsGroupLike(this.getFsGroup() != null ? this.getFsGroup() : new FSGroupStrategyOptionsBuilder().build());
    }

    @Override
    public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item) {
        return this.withNewFsGroupLike(this.getFsGroup() != null ? this.getFsGroup() : item);
    }

    @Override
    public Boolean isHostIPC() {
        return this.hostIPC;
    }

    @Override
    public A withHostIPC(Boolean hostIPC) {
        this.hostIPC = hostIPC;
        return (A)this;
    }

    @Override
    public Boolean hasHostIPC() {
        return this.hostIPC != null;
    }

    @Override
    public Boolean isHostNetwork() {
        return this.hostNetwork;
    }

    @Override
    public A withHostNetwork(Boolean hostNetwork) {
        this.hostNetwork = hostNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasHostNetwork() {
        return this.hostNetwork != null;
    }

    @Override
    public Boolean isHostPID() {
        return this.hostPID;
    }

    @Override
    public A withHostPID(Boolean hostPID) {
        this.hostPID = hostPID;
        return (A)this;
    }

    @Override
    public Boolean hasHostPID() {
        return this.hostPID != null;
    }

    @Override
    public A addToHostPorts(int index, HostPortRange item) {
        HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.hostPorts.add(index >= 0 ? index : this.hostPorts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToHostPorts(int index, HostPortRange item) {
        HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.hostPorts.size()) {
            this.hostPorts.add(builder);
        } else {
            this.hostPorts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHostPorts(HostPortRange ... items) {
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.add(builder);
            this.hostPorts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHostPorts(Collection<HostPortRange> items) {
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.add(builder);
            this.hostPorts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHostPorts(HostPortRange ... items) {
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.remove(builder);
            this.hostPorts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHostPorts(Collection<HostPortRange> items) {
        for (HostPortRange item : items) {
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            this._visitables.remove(builder);
            this.hostPorts.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HostPortRange> getHostPorts() {
        return PodSecurityPolicySpecFluentImpl.build(this.hostPorts);
    }

    @Override
    public List<HostPortRange> buildHostPorts() {
        return PodSecurityPolicySpecFluentImpl.build(this.hostPorts);
    }

    @Override
    public HostPortRange buildHostPort(int index) {
        return this.hostPorts.get(index).build();
    }

    @Override
    public HostPortRange buildFirstHostPort() {
        return this.hostPorts.get(0).build();
    }

    @Override
    public HostPortRange buildLastHostPort() {
        return this.hostPorts.get(this.hostPorts.size() - 1).build();
    }

    @Override
    public HostPortRange buildMatchingHostPort(Predicate<HostPortRangeBuilder> predicate) {
        for (HostPortRangeBuilder item : this.hostPorts) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withHostPorts(List<HostPortRange> hostPorts) {
        this._visitables.removeAll(this.hostPorts);
        this.hostPorts.clear();
        if (hostPorts != null) {
            for (HostPortRange item : hostPorts) {
                this.addToHostPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withHostPorts(HostPortRange ... hostPorts) {
        this.hostPorts.clear();
        if (hostPorts != null) {
            for (HostPortRange item : hostPorts) {
                this.addToHostPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHostPorts() {
        return this.hostPorts != null && !this.hostPorts.isEmpty();
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPort() {
        return new HostPortsNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPortLike(HostPortRange item) {
        return new HostPortsNestedImpl(-1, item);
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> setNewHostPortLike(int index, HostPortRange item) {
        return new HostPortsNestedImpl(index, item);
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editHostPort(int index) {
        if (this.hostPorts.size() <= index) {
            throw new RuntimeException("Can't edit hostPorts. Index exceeds size.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editFirstHostPort() {
        if (this.hostPorts.size() == 0) {
            throw new RuntimeException("Can't edit first hostPorts. The list is empty.");
        }
        return this.setNewHostPortLike(0, this.buildHostPort(0));
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editLastHostPort() {
        int index = this.hostPorts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostPorts. The list is empty.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    @Override
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editMatchingHostPort(Predicate<HostPortRangeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostPorts.size(); ++i) {
            if (!predicate.apply(this.hostPorts.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostPorts. No match found.");
        }
        return this.setNewHostPortLike(index, this.buildHostPort(index));
    }

    @Override
    public A addNewHostPort(Integer max, Integer min) {
        return this.addToHostPorts(new HostPortRange(max, min));
    }

    @Override
    public Boolean isPrivileged() {
        return this.privileged;
    }

    @Override
    public A withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (A)this;
    }

    @Override
    public Boolean hasPrivileged() {
        return this.privileged != null;
    }

    @Override
    public Boolean isReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    @Override
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    @Override
    public A addToRequiredDropCapabilities(int index, String item) {
        this.requiredDropCapabilities.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRequiredDropCapabilities(int index, String item) {
        this.requiredDropCapabilities.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRequiredDropCapabilities(Collection<String> items) {
        for (String item : items) {
            this.requiredDropCapabilities.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequiredDropCapabilities(String ... items) {
        for (String item : items) {
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRequiredDropCapabilities(Collection<String> items) {
        for (String item : items) {
            this.requiredDropCapabilities.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRequiredDropCapabilities() {
        return this.requiredDropCapabilities;
    }

    @Override
    public String getRequiredDropCapability(int index) {
        return this.requiredDropCapabilities.get(index);
    }

    @Override
    public String getFirstRequiredDropCapability() {
        return this.requiredDropCapabilities.get(0);
    }

    @Override
    public String getLastRequiredDropCapability() {
        return this.requiredDropCapabilities.get(this.requiredDropCapabilities.size() - 1);
    }

    @Override
    public String getMatchingRequiredDropCapability(Predicate<String> predicate) {
        for (String item : this.requiredDropCapabilities) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities) {
        this.requiredDropCapabilities.clear();
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withRequiredDropCapabilities(String ... requiredDropCapabilities) {
        this.requiredDropCapabilities.clear();
        if (requiredDropCapabilities != null) {
            for (String item : requiredDropCapabilities) {
                this.addToRequiredDropCapabilities(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRequiredDropCapabilities() {
        return this.requiredDropCapabilities != null && !this.requiredDropCapabilities.isEmpty();
    }

    @Override
    @Deprecated
    public KubernetesRunAsUserStrategyOptions getRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    @Override
    public KubernetesRunAsUserStrategyOptions buildRunAsUser() {
        return this.runAsUser != null ? this.runAsUser.build() : null;
    }

    @Override
    public A withRunAsUser(KubernetesRunAsUserStrategyOptions runAsUser) {
        this._visitables.remove(this.runAsUser);
        if (runAsUser != null) {
            this.runAsUser = new KubernetesRunAsUserStrategyOptionsBuilder(runAsUser);
            this._visitables.add(this.runAsUser);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUser() {
        return new RunAsUserNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUserLike(KubernetesRunAsUserStrategyOptions item) {
        return new RunAsUserNestedImpl(item);
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser());
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUser() {
        return this.withNewRunAsUserLike(this.getRunAsUser() != null ? this.getRunAsUser() : new KubernetesRunAsUserStrategyOptionsBuilder().build());
    }

    @Override
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUserLike(KubernetesRunAsUserStrategyOptions item) {
        return this.withNewRunAsUserLike(this.getRunAsUser() != null ? this.getRunAsUser() : item);
    }

    @Override
    @Deprecated
    public SELinuxStrategyOptions getSeLinux() {
        return this.seLinux != null ? this.seLinux.build() : null;
    }

    @Override
    public SELinuxStrategyOptions buildSeLinux() {
        return this.seLinux != null ? this.seLinux.build() : null;
    }

    @Override
    public A withSeLinux(SELinuxStrategyOptions seLinux) {
        this._visitables.remove(this.seLinux);
        if (seLinux != null) {
            this.seLinux = new SELinuxStrategyOptionsBuilder(seLinux);
            this._visitables.add(this.seLinux);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeLinux() {
        return this.seLinux != null;
    }

    @Override
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinux() {
        return new SeLinuxNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinuxLike(SELinuxStrategyOptions item) {
        return new SeLinuxNestedImpl(item);
    }

    @Override
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editSeLinux() {
        return this.withNewSeLinuxLike(this.getSeLinux());
    }

    @Override
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinux() {
        return this.withNewSeLinuxLike(this.getSeLinux() != null ? this.getSeLinux() : new SELinuxStrategyOptionsBuilder().build());
    }

    @Override
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinuxLike(SELinuxStrategyOptions item) {
        return this.withNewSeLinuxLike(this.getSeLinux() != null ? this.getSeLinux() : item);
    }

    @Override
    @Deprecated
    public SupplementalGroupsStrategyOptions getSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    @Override
    public SupplementalGroupsStrategyOptions buildSupplementalGroups() {
        return this.supplementalGroups != null ? this.supplementalGroups.build() : null;
    }

    @Override
    public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups) {
        this._visitables.remove(this.supplementalGroups);
        if (supplementalGroups != null) {
            this.supplementalGroups = new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups);
            this._visitables.add(this.supplementalGroups);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSupplementalGroups() {
        return this.supplementalGroups != null;
    }

    @Override
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroups() {
        return new SupplementalGroupsNestedImpl();
    }

    @Override
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return new SupplementalGroupsNestedImpl(item);
    }

    @Override
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups());
    }

    @Override
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups() {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups() != null ? this.getSupplementalGroups() : new SupplementalGroupsStrategyOptionsBuilder().build());
    }

    @Override
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item) {
        return this.withNewSupplementalGroupsLike(this.getSupplementalGroups() != null ? this.getSupplementalGroups() : item);
    }

    @Override
    public A addToVolumes(int index, String item) {
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, String item) {
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(String ... items) {
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<String> items) {
        for (String item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(String ... items) {
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<String> items) {
        for (String item : items) {
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumes() {
        return this.volumes;
    }

    @Override
    public String getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public String getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public String getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public String getMatchingVolume(Predicate<String> predicate) {
        for (String item : this.volumes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withVolumes(List<String> volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withVolumes(String ... volumes) {
        this.volumes.clear();
        if (volumes != null) {
            for (String item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodSecurityPolicySpecFluentImpl that = (PodSecurityPolicySpecFluentImpl)o;
        if (this.allowedCapabilities != null ? !this.allowedCapabilities.equals(that.allowedCapabilities) : that.allowedCapabilities != null) {
            return false;
        }
        if (this.defaultAddCapabilities != null ? !this.defaultAddCapabilities.equals(that.defaultAddCapabilities) : that.defaultAddCapabilities != null) {
            return false;
        }
        if (this.fsGroup != null ? !this.fsGroup.equals(that.fsGroup) : that.fsGroup != null) {
            return false;
        }
        if (this.hostIPC != null ? !this.hostIPC.equals(that.hostIPC) : that.hostIPC != null) {
            return false;
        }
        if (this.hostNetwork != null ? !this.hostNetwork.equals(that.hostNetwork) : that.hostNetwork != null) {
            return false;
        }
        if (this.hostPID != null ? !this.hostPID.equals(that.hostPID) : that.hostPID != null) {
            return false;
        }
        if (this.hostPorts != null ? !this.hostPorts.equals(that.hostPorts) : that.hostPorts != null) {
            return false;
        }
        if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) {
            return false;
        }
        if (this.readOnlyRootFilesystem != null ? !this.readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) : that.readOnlyRootFilesystem != null) {
            return false;
        }
        if (this.requiredDropCapabilities != null ? !this.requiredDropCapabilities.equals(that.requiredDropCapabilities) : that.requiredDropCapabilities != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        if (this.seLinux != null ? !this.seLinux.equals(that.seLinux) : that.seLinux != null) {
            return false;
        }
        if (this.supplementalGroups != null ? !this.supplementalGroups.equals(that.supplementalGroups) : that.supplementalGroups != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public class SupplementalGroupsNestedImpl<N>
    extends SupplementalGroupsStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>>
    implements PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>,
    Nested<N> {
        private final SupplementalGroupsStrategyOptionsBuilder builder;

        SupplementalGroupsNestedImpl(SupplementalGroupsStrategyOptions item) {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
        }

        SupplementalGroupsNestedImpl() {
            this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.withSupplementalGroups(this.builder.build());
        }

        @Override
        public N endSupplementalGroups() {
            return this.and();
        }
    }

    public class SeLinuxNestedImpl<N>
    extends SELinuxStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.SeLinuxNested<N>>
    implements PodSecurityPolicySpecFluent.SeLinuxNested<N>,
    Nested<N> {
        private final SELinuxStrategyOptionsBuilder builder;

        SeLinuxNestedImpl(SELinuxStrategyOptions item) {
            this.builder = new SELinuxStrategyOptionsBuilder(this, item);
        }

        SeLinuxNestedImpl() {
            this.builder = new SELinuxStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.withSeLinux(this.builder.build());
        }

        @Override
        public N endSeLinux() {
            return this.and();
        }
    }

    public class RunAsUserNestedImpl<N>
    extends KubernetesRunAsUserStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.RunAsUserNested<N>>
    implements PodSecurityPolicySpecFluent.RunAsUserNested<N>,
    Nested<N> {
        private final KubernetesRunAsUserStrategyOptionsBuilder builder;

        RunAsUserNestedImpl(KubernetesRunAsUserStrategyOptions item) {
            this.builder = new KubernetesRunAsUserStrategyOptionsBuilder(this, item);
        }

        RunAsUserNestedImpl() {
            this.builder = new KubernetesRunAsUserStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.withRunAsUser(this.builder.build());
        }

        @Override
        public N endRunAsUser() {
            return this.and();
        }
    }

    public class HostPortsNestedImpl<N>
    extends HostPortRangeFluentImpl<PodSecurityPolicySpecFluent.HostPortsNested<N>>
    implements PodSecurityPolicySpecFluent.HostPortsNested<N>,
    Nested<N> {
        private final HostPortRangeBuilder builder;
        private final int index;

        HostPortsNestedImpl(int index, HostPortRange item) {
            this.index = index;
            this.builder = new HostPortRangeBuilder(this, item);
        }

        HostPortsNestedImpl() {
            this.index = -1;
            this.builder = new HostPortRangeBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.setToHostPorts(this.index, this.builder.build());
        }

        @Override
        public N endHostPort() {
            return this.and();
        }
    }

    public class FsGroupNestedImpl<N>
    extends FSGroupStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.FsGroupNested<N>>
    implements PodSecurityPolicySpecFluent.FsGroupNested<N>,
    Nested<N> {
        private final FSGroupStrategyOptionsBuilder builder;

        FsGroupNestedImpl(FSGroupStrategyOptions item) {
            this.builder = new FSGroupStrategyOptionsBuilder(this, item);
        }

        FsGroupNestedImpl() {
            this.builder = new FSGroupStrategyOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodSecurityPolicySpecFluentImpl.this.withFsGroup(this.builder.build());
        }

        @Override
        public N endFsGroup() {
            return this.and();
        }
    }
}

