/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_2.extensions;

import io.fabric8.kubernetes.api.builder.v3_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v3_2.extensions.NetworkPolicySpec;
import io.fabric8.kubernetes.api.model.v3_2.extensions.NetworkPolicySpecFluent;
import io.fabric8.kubernetes.api.model.v3_2.extensions.NetworkPolicySpecFluentImpl;

public class NetworkPolicySpecBuilder
extends NetworkPolicySpecFluentImpl<NetworkPolicySpecBuilder>
implements VisitableBuilder<NetworkPolicySpec, NetworkPolicySpecBuilder> {
    NetworkPolicySpecFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkPolicySpecBuilder() {
        this(true);
    }

    public NetworkPolicySpecBuilder(Boolean validationEnabled) {
        this(new NetworkPolicySpec(), validationEnabled);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicySpec(), validationEnabled);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent, NetworkPolicySpec instance) {
        this(fluent, instance, true);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpecFluent<?> fluent, NetworkPolicySpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withIngress(instance.getIngress());
        fluent.withPodSelector(instance.getPodSelector());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpec instance) {
        this(instance, (Boolean)true);
    }

    public NetworkPolicySpecBuilder(NetworkPolicySpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withIngress(instance.getIngress());
        this.withPodSelector(instance.getPodSelector());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NetworkPolicySpec build() {
        NetworkPolicySpec buildable = new NetworkPolicySpec(this.fluent.getIngress(), this.fluent.getPodSelector());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicySpecBuilder that = (NetworkPolicySpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

