/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_2.authorization;

import io.fabric8.kubernetes.api.builder.v3_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_2.Nested;
import io.fabric8.kubernetes.api.builder.v3_2.Predicate;
import io.fabric8.kubernetes.api.model.v3_2.authorization.NonResourceAttributes;
import io.fabric8.kubernetes.api.model.v3_2.authorization.NonResourceAttributesBuilder;
import io.fabric8.kubernetes.api.model.v3_2.authorization.NonResourceAttributesFluentImpl;
import io.fabric8.kubernetes.api.model.v3_2.authorization.ResourceAttributes;
import io.fabric8.kubernetes.api.model.v3_2.authorization.ResourceAttributesBuilder;
import io.fabric8.kubernetes.api.model.v3_2.authorization.ResourceAttributesFluentImpl;
import io.fabric8.kubernetes.api.model.v3_2.authorization.SubjectAccessReviewSpec;
import io.fabric8.kubernetes.api.model.v3_2.authorization.SubjectAccessReviewSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SubjectAccessReviewSpecFluentImpl<A extends SubjectAccessReviewSpecFluent<A>>
extends BaseFluent<A>
implements SubjectAccessReviewSpecFluent<A> {
    private Map<String, ArrayList<String>> extra = new LinkedHashMap<String, ArrayList<String>>();
    private List<String> groups = new ArrayList<String>();
    private NonResourceAttributesBuilder nonResourceAttributes;
    private ResourceAttributesBuilder resourceAttributes;
    private String user;

    public SubjectAccessReviewSpecFluentImpl() {
    }

    public SubjectAccessReviewSpecFluentImpl(SubjectAccessReviewSpec instance) {
        this.withExtra(instance.getExtra());
        this.withGroups(instance.getGroups());
        this.withNonResourceAttributes(instance.getNonResourceAttributes());
        this.withResourceAttributes(instance.getResourceAttributes());
        this.withUser(instance.getUser());
    }

    @Override
    public A addToExtra(String key, ArrayList<String> value) {
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExtra(Map<String, ArrayList<String>> map) {
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(String key) {
        if (key != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(Map<String, ArrayList<String>> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, ArrayList<String>> getExtra() {
        return this.extra;
    }

    @Override
    public A withExtra(Map<String, ArrayList<String>> extra) {
        this.extra.clear();
        if (extra != null) {
            this.extra.putAll(extra);
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtra() {
        return this.extra != null;
    }

    @Override
    public A addToGroups(int index, String item) {
        this.groups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroups(int index, String item) {
        this.groups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroups(String ... items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<String> items) {
        for (String item : items) {
            this.groups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(String ... items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {
            this.groups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroups() {
        return this.groups;
    }

    @Override
    public String getGroup(int index) {
        return this.groups.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.groups.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.groups.get(this.groups.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.groups) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withGroups(List<String> groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withGroups(String ... groups) {
        this.groups.clear();
        if (groups != null) {
            for (String item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    @Deprecated
    public NonResourceAttributes getNonResourceAttributes() {
        return this.nonResourceAttributes != null ? this.nonResourceAttributes.build() : null;
    }

    @Override
    public NonResourceAttributes buildNonResourceAttributes() {
        return this.nonResourceAttributes != null ? this.nonResourceAttributes.build() : null;
    }

    @Override
    public A withNonResourceAttributes(NonResourceAttributes nonResourceAttributes) {
        this._visitables.remove(this.nonResourceAttributes);
        if (nonResourceAttributes != null) {
            this.nonResourceAttributes = new NonResourceAttributesBuilder(nonResourceAttributes);
            this._visitables.add(this.nonResourceAttributes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNonResourceAttributes() {
        return this.nonResourceAttributes != null;
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributes() {
        return new NonResourceAttributesNestedImpl();
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributesLike(NonResourceAttributes item) {
        return new NonResourceAttributesNestedImpl(item);
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes());
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes() != null ? this.getNonResourceAttributes() : new NonResourceAttributesBuilder().build());
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributesLike(NonResourceAttributes item) {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes() != null ? this.getNonResourceAttributes() : item);
    }

    @Override
    public A withNewNonResourceAttributes(String path, String verb) {
        return this.withNonResourceAttributes(new NonResourceAttributes(path, verb));
    }

    @Override
    @Deprecated
    public ResourceAttributes getResourceAttributes() {
        return this.resourceAttributes != null ? this.resourceAttributes.build() : null;
    }

    @Override
    public ResourceAttributes buildResourceAttributes() {
        return this.resourceAttributes != null ? this.resourceAttributes.build() : null;
    }

    @Override
    public A withResourceAttributes(ResourceAttributes resourceAttributes) {
        this._visitables.remove(this.resourceAttributes);
        if (resourceAttributes != null) {
            this.resourceAttributes = new ResourceAttributesBuilder(resourceAttributes);
            this._visitables.add(this.resourceAttributes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceAttributes() {
        return this.resourceAttributes != null;
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributes() {
        return new ResourceAttributesNestedImpl();
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributesLike(ResourceAttributes item) {
        return new ResourceAttributesNestedImpl(item);
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editResourceAttributes() {
        return this.withNewResourceAttributesLike(this.getResourceAttributes());
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributes() {
        return this.withNewResourceAttributesLike(this.getResourceAttributes() != null ? this.getResourceAttributes() : new ResourceAttributesBuilder().build());
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributesLike(ResourceAttributes item) {
        return this.withNewResourceAttributesLike(this.getResourceAttributes() != null ? this.getResourceAttributes() : item);
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubjectAccessReviewSpecFluentImpl that = (SubjectAccessReviewSpecFluentImpl)o;
        if (this.extra != null ? !this.extra.equals(that.extra) : that.extra != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.nonResourceAttributes != null ? !this.nonResourceAttributes.equals(that.nonResourceAttributes) : that.nonResourceAttributes != null) {
            return false;
        }
        if (this.resourceAttributes != null ? !this.resourceAttributes.equals(that.resourceAttributes) : that.resourceAttributes != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class ResourceAttributesNestedImpl<N>
    extends ResourceAttributesFluentImpl<SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>>
    implements SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>,
    Nested<N> {
        private final ResourceAttributesBuilder builder;

        ResourceAttributesNestedImpl(ResourceAttributes item) {
            this.builder = new ResourceAttributesBuilder(this, item);
        }

        ResourceAttributesNestedImpl() {
            this.builder = new ResourceAttributesBuilder(this);
        }

        @Override
        public N and() {
            return (N)SubjectAccessReviewSpecFluentImpl.this.withResourceAttributes(this.builder.build());
        }

        @Override
        public N endResourceAttributes() {
            return this.and();
        }
    }

    public class NonResourceAttributesNestedImpl<N>
    extends NonResourceAttributesFluentImpl<SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>>
    implements SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>,
    Nested<N> {
        private final NonResourceAttributesBuilder builder;

        NonResourceAttributesNestedImpl(NonResourceAttributes item) {
            this.builder = new NonResourceAttributesBuilder(this, item);
        }

        NonResourceAttributesNestedImpl() {
            this.builder = new NonResourceAttributesBuilder(this);
        }

        @Override
        public N and() {
            return (N)SubjectAccessReviewSpecFluentImpl.this.withNonResourceAttributes(this.builder.build());
        }

        @Override
        public N endNonResourceAttributes() {
            return this.and();
        }
    }
}

