/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_2.authentication;

import io.fabric8.kubernetes.api.builder.v3_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_2.Nested;
import io.fabric8.kubernetes.api.model.v3_2.ObjectMeta;
import io.fabric8.kubernetes.api.model.v3_2.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v3_2.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v3_2.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.v3_2.authentication.TokenReviewFluent;
import io.fabric8.kubernetes.api.model.v3_2.authentication.TokenReviewSpec;
import io.fabric8.kubernetes.api.model.v3_2.authentication.TokenReviewSpecBuilder;
import io.fabric8.kubernetes.api.model.v3_2.authentication.TokenReviewSpecFluentImpl;
import io.fabric8.kubernetes.api.model.v3_2.authentication.TokenReviewStatus;
import io.fabric8.kubernetes.api.model.v3_2.authentication.TokenReviewStatusBuilder;
import io.fabric8.kubernetes.api.model.v3_2.authentication.TokenReviewStatusFluentImpl;

public class TokenReviewFluentImpl<A extends TokenReviewFluent<A>>
extends BaseFluent<A>
implements TokenReviewFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private TokenReviewSpecBuilder spec;
    private TokenReviewStatusBuilder status;

    public TokenReviewFluentImpl() {
    }

    public TokenReviewFluentImpl(TokenReview instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public TokenReviewFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public TokenReviewFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public TokenReviewFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public TokenReviewFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public TokenReviewFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public TokenReviewSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public TokenReviewSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(TokenReviewSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new TokenReviewSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public TokenReviewFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public TokenReviewFluent.SpecNested<A> withNewSpecLike(TokenReviewSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public TokenReviewFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public TokenReviewFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new TokenReviewSpecBuilder().build());
    }

    @Override
    public TokenReviewFluent.SpecNested<A> editOrNewSpecLike(TokenReviewSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    public A withNewSpec(String token) {
        return this.withSpec(new TokenReviewSpec(token));
    }

    @Override
    @Deprecated
    public TokenReviewStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public TokenReviewStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(TokenReviewStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new TokenReviewStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public TokenReviewFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public TokenReviewFluent.StatusNested<A> withNewStatusLike(TokenReviewStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public TokenReviewFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public TokenReviewFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new TokenReviewStatusBuilder().build());
    }

    @Override
    public TokenReviewFluent.StatusNested<A> editOrNewStatusLike(TokenReviewStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TokenReviewFluentImpl that = (TokenReviewFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends TokenReviewStatusFluentImpl<TokenReviewFluent.StatusNested<N>>
    implements TokenReviewFluent.StatusNested<N>,
    Nested<N> {
        private final TokenReviewStatusBuilder builder;

        StatusNestedImpl(TokenReviewStatus item) {
            this.builder = new TokenReviewStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new TokenReviewStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)TokenReviewFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends TokenReviewSpecFluentImpl<TokenReviewFluent.SpecNested<N>>
    implements TokenReviewFluent.SpecNested<N>,
    Nested<N> {
        private final TokenReviewSpecBuilder builder;

        SpecNestedImpl(TokenReviewSpec item) {
            this.builder = new TokenReviewSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new TokenReviewSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)TokenReviewFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<TokenReviewFluent.MetadataNested<N>>
    implements TokenReviewFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)TokenReviewFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

