/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_2;

import io.fabric8.kubernetes.api.builder.v3_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_2.Nested;
import io.fabric8.kubernetes.api.builder.v3_2.Predicate;
import io.fabric8.kubernetes.api.model.v3_2.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v3_2.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v3_2.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v3_2.RBDVolumeSource;
import io.fabric8.kubernetes.api.model.v3_2.RBDVolumeSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RBDVolumeSourceFluentImpl<A extends RBDVolumeSourceFluent<A>>
extends BaseFluent<A>
implements RBDVolumeSourceFluent<A> {
    private String fsType;
    private String image;
    private String keyring;
    private List<String> monitors = new ArrayList<String>();
    private String pool;
    private Boolean readOnly;
    private LocalObjectReferenceBuilder secretRef;
    private String user;

    public RBDVolumeSourceFluentImpl() {
    }

    public RBDVolumeSourceFluentImpl(RBDVolumeSource instance) {
        this.withFsType(instance.getFsType());
        this.withImage(instance.getImage());
        this.withKeyring(instance.getKeyring());
        this.withMonitors(instance.getMonitors());
        this.withPool(instance.getPool());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withUser(instance.getUser());
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public String getKeyring() {
        return this.keyring;
    }

    @Override
    public A withKeyring(String keyring) {
        this.keyring = keyring;
        return (A)this;
    }

    @Override
    public Boolean hasKeyring() {
        return this.keyring != null;
    }

    @Override
    public A addToMonitors(int index, String item) {
        this.monitors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMonitors(int index, String item) {
        this.monitors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMonitors(String ... items) {
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMonitors(Collection<String> items) {
        for (String item : items) {
            this.monitors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMonitors(String ... items) {
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMonitors(Collection<String> items) {
        for (String item : items) {
            this.monitors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMonitors() {
        return this.monitors;
    }

    @Override
    public String getMonitor(int index) {
        return this.monitors.get(index);
    }

    @Override
    public String getFirstMonitor() {
        return this.monitors.get(0);
    }

    @Override
    public String getLastMonitor() {
        return this.monitors.get(this.monitors.size() - 1);
    }

    @Override
    public String getMatchingMonitor(Predicate<String> predicate) {
        for (String item : this.monitors) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withMonitors(List<String> monitors) {
        this.monitors.clear();
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withMonitors(String ... monitors) {
        this.monitors.clear();
        if (monitors != null) {
            for (String item : monitors) {
                this.addToMonitors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMonitors() {
        return this.monitors != null && !this.monitors.isEmpty();
    }

    @Override
    public String getPool() {
        return this.pool;
    }

    @Override
    public A withPool(String pool) {
        this.pool = pool;
        return (A)this;
    }

    @Override
    public Boolean hasPool() {
        return this.pool != null;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public RBDVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public RBDVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public RBDVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public RBDVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public RBDVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public A withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RBDVolumeSourceFluentImpl that = (RBDVolumeSourceFluentImpl)o;
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.keyring != null ? !this.keyring.equals(that.keyring) : that.keyring != null) {
            return false;
        }
        if (this.monitors != null ? !this.monitors.equals(that.monitors) : that.monitors != null) {
            return false;
        }
        if (this.pool != null ? !this.pool.equals(that.pool) : that.pool != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<RBDVolumeSourceFluent.SecretRefNested<N>>
    implements RBDVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)RBDVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

