/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_2;

import io.fabric8.kubernetes.api.builder.v3_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v3_2.PodStatus;
import io.fabric8.kubernetes.api.model.v3_2.PodStatusFluent;
import io.fabric8.kubernetes.api.model.v3_2.PodStatusFluentImpl;

public class PodStatusBuilder
extends PodStatusFluentImpl<PodStatusBuilder>
implements VisitableBuilder<PodStatus, PodStatusBuilder> {
    PodStatusFluent<?> fluent;
    Boolean validationEnabled;

    public PodStatusBuilder() {
        this(true);
    }

    public PodStatusBuilder(Boolean validationEnabled) {
        this(new PodStatus(), validationEnabled);
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodStatus(), validationEnabled);
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent, PodStatus instance) {
        this(fluent, instance, true);
    }

    public PodStatusBuilder(PodStatusFluent<?> fluent, PodStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConditions(instance.getConditions());
        fluent.withContainerStatuses(instance.getContainerStatuses());
        fluent.withHostIP(instance.getHostIP());
        fluent.withInitContainerStatuses(instance.getInitContainerStatuses());
        fluent.withMessage(instance.getMessage());
        fluent.withPhase(instance.getPhase());
        fluent.withPodIP(instance.getPodIP());
        fluent.withQosClass(instance.getQosClass());
        fluent.withReason(instance.getReason());
        fluent.withStartTime(instance.getStartTime());
        this.validationEnabled = validationEnabled;
    }

    public PodStatusBuilder(PodStatus instance) {
        this(instance, (Boolean)true);
    }

    public PodStatusBuilder(PodStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConditions(instance.getConditions());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withHostIP(instance.getHostIP());
        this.withInitContainerStatuses(instance.getInitContainerStatuses());
        this.withMessage(instance.getMessage());
        this.withPhase(instance.getPhase());
        this.withPodIP(instance.getPodIP());
        this.withQosClass(instance.getQosClass());
        this.withReason(instance.getReason());
        this.withStartTime(instance.getStartTime());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PodStatus build() {
        PodStatus buildable = new PodStatus(this.fluent.getConditions(), this.fluent.getContainerStatuses(), this.fluent.getHostIP(), this.fluent.getInitContainerStatuses(), this.fluent.getMessage(), this.fluent.getPhase(), this.fluent.getPodIP(), this.fluent.getQosClass(), this.fluent.getReason(), this.fluent.getStartTime());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodStatusBuilder that = (PodStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

