/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_2;

import io.fabric8.kubernetes.api.builder.v3_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v3_2.Pod;
import io.fabric8.kubernetes.api.model.v3_2.PodFluent;
import io.fabric8.kubernetes.api.model.v3_2.PodFluentImpl;

public class PodBuilder
extends PodFluentImpl<PodBuilder>
implements VisitableBuilder<Pod, PodBuilder> {
    PodFluent<?> fluent;
    Boolean validationEnabled;

    public PodBuilder() {
        this(true);
    }

    public PodBuilder(Boolean validationEnabled) {
        this(new Pod(), validationEnabled);
    }

    public PodBuilder(PodFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodBuilder(PodFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Pod(), validationEnabled);
    }

    public PodBuilder(PodFluent<?> fluent, Pod instance) {
        this(fluent, instance, true);
    }

    public PodBuilder(PodFluent<?> fluent, Pod instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public PodBuilder(Pod instance) {
        this(instance, (Boolean)true);
    }

    public PodBuilder(Pod instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Pod build() {
        Pod buildable = new Pod(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodBuilder that = (PodBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

