/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_2;

import io.fabric8.kubernetes.api.builder.v3_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v3_2.LabelSelector;
import io.fabric8.kubernetes.api.model.v3_2.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.v3_2.LabelSelectorFluentImpl;

public class LabelSelectorBuilder
extends LabelSelectorFluentImpl<LabelSelectorBuilder>
implements VisitableBuilder<LabelSelector, LabelSelectorBuilder> {
    LabelSelectorFluent<?> fluent;
    Boolean validationEnabled;

    public LabelSelectorBuilder() {
        this(true);
    }

    public LabelSelectorBuilder(Boolean validationEnabled) {
        this(new LabelSelector(), validationEnabled);
    }

    public LabelSelectorBuilder(LabelSelectorFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public LabelSelectorBuilder(LabelSelectorFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new LabelSelector(), validationEnabled);
    }

    public LabelSelectorBuilder(LabelSelectorFluent<?> fluent, LabelSelector instance) {
        this(fluent, instance, true);
    }

    public LabelSelectorBuilder(LabelSelectorFluent<?> fluent, LabelSelector instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMatchExpressions(instance.getMatchExpressions());
        fluent.withMatchLabels(instance.getMatchLabels());
        this.validationEnabled = validationEnabled;
    }

    public LabelSelectorBuilder(LabelSelector instance) {
        this(instance, (Boolean)true);
    }

    public LabelSelectorBuilder(LabelSelector instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMatchExpressions(instance.getMatchExpressions());
        this.withMatchLabels(instance.getMatchLabels());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public LabelSelector build() {
        LabelSelector buildable = new LabelSelector(this.fluent.getMatchExpressions(), this.fluent.getMatchLabels());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LabelSelectorBuilder that = (LabelSelectorBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

