/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_2;

import io.fabric8.kubernetes.api.builder.v3_2.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_2.Nested;
import io.fabric8.kubernetes.api.builder.v3_2.Predicate;
import io.fabric8.kubernetes.api.model.v3_2.ISCSIVolumeSource;
import io.fabric8.kubernetes.api.model.v3_2.ISCSIVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v3_2.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v3_2.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v3_2.LocalObjectReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ISCSIVolumeSourceFluentImpl<A extends ISCSIVolumeSourceFluent<A>>
extends BaseFluent<A>
implements ISCSIVolumeSourceFluent<A> {
    private Boolean chapAuthDiscovery;
    private Boolean chapAuthSession;
    private String fsType;
    private String iqn;
    private String iscsiInterface;
    private Integer lun;
    private List<String> portals = new ArrayList<String>();
    private Boolean readOnly;
    private LocalObjectReferenceBuilder secretRef;
    private String targetPortal;

    public ISCSIVolumeSourceFluentImpl() {
    }

    public ISCSIVolumeSourceFluentImpl(ISCSIVolumeSource instance) {
        this.withChapAuthDiscovery(instance.getChapAuthDiscovery());
        this.withChapAuthSession(instance.getChapAuthSession());
        this.withFsType(instance.getFsType());
        this.withIqn(instance.getIqn());
        this.withIscsiInterface(instance.getIscsiInterface());
        this.withLun(instance.getLun());
        this.withPortals(instance.getPortals());
        this.withReadOnly(instance.getReadOnly());
        this.withSecretRef(instance.getSecretRef());
        this.withTargetPortal(instance.getTargetPortal());
    }

    @Override
    public Boolean isChapAuthDiscovery() {
        return this.chapAuthDiscovery;
    }

    @Override
    public A withChapAuthDiscovery(Boolean chapAuthDiscovery) {
        this.chapAuthDiscovery = chapAuthDiscovery;
        return (A)this;
    }

    @Override
    public Boolean hasChapAuthDiscovery() {
        return this.chapAuthDiscovery != null;
    }

    @Override
    public Boolean isChapAuthSession() {
        return this.chapAuthSession;
    }

    @Override
    public A withChapAuthSession(Boolean chapAuthSession) {
        this.chapAuthSession = chapAuthSession;
        return (A)this;
    }

    @Override
    public Boolean hasChapAuthSession() {
        return this.chapAuthSession != null;
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    public String getIqn() {
        return this.iqn;
    }

    @Override
    public A withIqn(String iqn) {
        this.iqn = iqn;
        return (A)this;
    }

    @Override
    public Boolean hasIqn() {
        return this.iqn != null;
    }

    @Override
    public String getIscsiInterface() {
        return this.iscsiInterface;
    }

    @Override
    public A withIscsiInterface(String iscsiInterface) {
        this.iscsiInterface = iscsiInterface;
        return (A)this;
    }

    @Override
    public Boolean hasIscsiInterface() {
        return this.iscsiInterface != null;
    }

    @Override
    public Integer getLun() {
        return this.lun;
    }

    @Override
    public A withLun(Integer lun) {
        this.lun = lun;
        return (A)this;
    }

    @Override
    public Boolean hasLun() {
        return this.lun != null;
    }

    @Override
    public A addToPortals(int index, String item) {
        this.portals.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPortals(int index, String item) {
        this.portals.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPortals(String ... items) {
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPortals(Collection<String> items) {
        for (String item : items) {
            this.portals.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPortals(String ... items) {
        for (String item : items) {
            this.portals.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPortals(Collection<String> items) {
        for (String item : items) {
            this.portals.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPortals() {
        return this.portals;
    }

    @Override
    public String getPortal(int index) {
        return this.portals.get(index);
    }

    @Override
    public String getFirstPortal() {
        return this.portals.get(0);
    }

    @Override
    public String getLastPortal() {
        return this.portals.get(this.portals.size() - 1);
    }

    @Override
    public String getMatchingPortal(Predicate<String> predicate) {
        for (String item : this.portals) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public A withPortals(List<String> portals) {
        this.portals.clear();
        if (portals != null) {
            for (String item : portals) {
                this.addToPortals(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withPortals(String ... portals) {
        this.portals.clear();
        if (portals != null) {
            for (String item : portals) {
                this.addToPortals(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPortals() {
        return this.portals != null && !this.portals.isEmpty();
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    @Override
    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.remove(this.secretRef);
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.add(this.secretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretRef() {
        return this.secretRef != null;
    }

    @Override
    public ISCSIVolumeSourceFluent.SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNestedImpl();
    }

    @Override
    public ISCSIVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNestedImpl(item);
    }

    @Override
    public ISCSIVolumeSourceFluent.SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef());
    }

    @Override
    public ISCSIVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ISCSIVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(this.getSecretRef() != null ? this.getSecretRef() : item);
    }

    @Override
    public A withNewSecretRef(String name) {
        return this.withSecretRef(new LocalObjectReference(name));
    }

    @Override
    public String getTargetPortal() {
        return this.targetPortal;
    }

    @Override
    public A withTargetPortal(String targetPortal) {
        this.targetPortal = targetPortal;
        return (A)this;
    }

    @Override
    public Boolean hasTargetPortal() {
        return this.targetPortal != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ISCSIVolumeSourceFluentImpl that = (ISCSIVolumeSourceFluentImpl)o;
        if (this.chapAuthDiscovery != null ? !this.chapAuthDiscovery.equals(that.chapAuthDiscovery) : that.chapAuthDiscovery != null) {
            return false;
        }
        if (this.chapAuthSession != null ? !this.chapAuthSession.equals(that.chapAuthSession) : that.chapAuthSession != null) {
            return false;
        }
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.iqn != null ? !this.iqn.equals(that.iqn) : that.iqn != null) {
            return false;
        }
        if (this.iscsiInterface != null ? !this.iscsiInterface.equals(that.iscsiInterface) : that.iscsiInterface != null) {
            return false;
        }
        if (this.lun != null ? !this.lun.equals(that.lun) : that.lun != null) {
            return false;
        }
        if (this.portals != null ? !this.portals.equals(that.portals) : that.portals != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.secretRef != null ? !this.secretRef.equals(that.secretRef) : that.secretRef != null) {
            return false;
        }
        return !(this.targetPortal != null ? !this.targetPortal.equals(that.targetPortal) : that.targetPortal != null);
    }

    public class SecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ISCSIVolumeSourceFluent.SecretRefNested<N>>
    implements ISCSIVolumeSourceFluent.SecretRefNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ISCSIVolumeSourceFluentImpl.this.withSecretRef(this.builder.build());
        }

        @Override
        public N endSecretRef() {
            return this.and();
        }
    }
}

