/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_2;

import io.fabric8.kubernetes.api.builder.v3_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v3_2.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.v3_2.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.v3_2.HorizontalPodAutoscalerFluentImpl;

public class HorizontalPodAutoscalerBuilder
extends HorizontalPodAutoscalerFluentImpl<HorizontalPodAutoscalerBuilder>
implements VisitableBuilder<HorizontalPodAutoscaler, HorizontalPodAutoscalerBuilder> {
    HorizontalPodAutoscalerFluent<?> fluent;
    Boolean validationEnabled;

    public HorizontalPodAutoscalerBuilder() {
        this(true);
    }

    public HorizontalPodAutoscalerBuilder(Boolean validationEnabled) {
        this(new HorizontalPodAutoscaler(), validationEnabled);
    }

    public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscalerFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscalerFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HorizontalPodAutoscaler(), validationEnabled);
    }

    public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscalerFluent<?> fluent, HorizontalPodAutoscaler instance) {
        this(fluent, instance, true);
    }

    public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscalerFluent<?> fluent, HorizontalPodAutoscaler instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscaler instance) {
        this(instance, (Boolean)true);
    }

    public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscaler instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public HorizontalPodAutoscaler build() {
        HorizontalPodAutoscaler buildable = new HorizontalPodAutoscaler(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerBuilder that = (HorizontalPodAutoscalerBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

