/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_2;

import io.fabric8.kubernetes.api.builder.v3_2.ValidationUtils;
import io.fabric8.kubernetes.api.builder.v3_2.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v3_2.Affinity;
import io.fabric8.kubernetes.api.model.v3_2.AffinityFluent;
import io.fabric8.kubernetes.api.model.v3_2.AffinityFluentImpl;

public class AffinityBuilder
extends AffinityFluentImpl<AffinityBuilder>
implements VisitableBuilder<Affinity, AffinityBuilder> {
    AffinityFluent<?> fluent;
    Boolean validationEnabled;

    public AffinityBuilder() {
        this(true);
    }

    public AffinityBuilder(Boolean validationEnabled) {
        this(new Affinity(), validationEnabled);
    }

    public AffinityBuilder(AffinityFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Affinity(), validationEnabled);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Affinity instance) {
        this(fluent, instance, true);
    }

    public AffinityBuilder(AffinityFluent<?> fluent, Affinity instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNodeAffinity(instance.getNodeAffinity());
        fluent.withPodAffinity(instance.getPodAffinity());
        fluent.withPodAntiAffinity(instance.getPodAntiAffinity());
        this.validationEnabled = validationEnabled;
    }

    public AffinityBuilder(Affinity instance) {
        this(instance, (Boolean)true);
    }

    public AffinityBuilder(Affinity instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNodeAffinity(instance.getNodeAffinity());
        this.withPodAffinity(instance.getPodAffinity());
        this.withPodAntiAffinity(instance.getPodAntiAffinity());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Affinity build() {
        Affinity buildable = new Affinity(this.fluent.getNodeAffinity(), this.fluent.getPodAffinity(), this.fluent.getPodAntiAffinity());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AffinityBuilder that = (AffinityBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

