/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v3_1;

import io.fabric8.kubernetes.api.builder.v3_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_1.Nested;
import io.fabric8.openshift.api.model.v3_1.NamedRoleBinding;
import io.fabric8.openshift.api.model.v3_1.NamedRoleBindingFluent;
import io.fabric8.openshift.api.model.v3_1.RoleBinding;
import io.fabric8.openshift.api.model.v3_1.RoleBindingBuilder;
import io.fabric8.openshift.api.model.v3_1.RoleBindingFluentImpl;

public class NamedRoleBindingFluentImpl<A extends NamedRoleBindingFluent<A>>
extends BaseFluent<A>
implements NamedRoleBindingFluent<A> {
    private String name;
    private RoleBindingBuilder roleBinding;

    public NamedRoleBindingFluentImpl() {
    }

    public NamedRoleBindingFluentImpl(NamedRoleBinding instance) {
        this.withName(instance.getName());
        this.withRoleBinding(instance.getRoleBinding());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public RoleBinding getRoleBinding() {
        return this.roleBinding != null ? this.roleBinding.build() : null;
    }

    @Override
    public RoleBinding buildRoleBinding() {
        return this.roleBinding != null ? this.roleBinding.build() : null;
    }

    @Override
    public A withRoleBinding(RoleBinding roleBinding) {
        this._visitables.remove(this.roleBinding);
        if (roleBinding != null) {
            this.roleBinding = new RoleBindingBuilder(roleBinding);
            this._visitables.add(this.roleBinding);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleBinding() {
        return this.roleBinding != null;
    }

    @Override
    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBinding() {
        return new RoleBindingNestedImpl();
    }

    @Override
    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBindingLike(RoleBinding item) {
        return new RoleBindingNestedImpl(item);
    }

    @Override
    public NamedRoleBindingFluent.RoleBindingNested<A> editRoleBinding() {
        return this.withNewRoleBindingLike(this.getRoleBinding());
    }

    @Override
    public NamedRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBinding() {
        return this.withNewRoleBindingLike(this.getRoleBinding() != null ? this.getRoleBinding() : new RoleBindingBuilder().build());
    }

    @Override
    public NamedRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBindingLike(RoleBinding item) {
        return this.withNewRoleBindingLike(this.getRoleBinding() != null ? this.getRoleBinding() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedRoleBindingFluentImpl that = (NamedRoleBindingFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.roleBinding != null ? !this.roleBinding.equals(that.roleBinding) : that.roleBinding != null);
    }

    public class RoleBindingNestedImpl<N>
    extends RoleBindingFluentImpl<NamedRoleBindingFluent.RoleBindingNested<N>>
    implements NamedRoleBindingFluent.RoleBindingNested<N>,
    Nested<N> {
        private final RoleBindingBuilder builder;

        RoleBindingNestedImpl(RoleBinding item) {
            this.builder = new RoleBindingBuilder(this, item);
        }

        RoleBindingNestedImpl() {
            this.builder = new RoleBindingBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamedRoleBindingFluentImpl.this.withRoleBinding(this.builder.build());
        }

        @Override
        public N endRoleBinding() {
            return this.and();
        }
    }
}

