/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v3_1;

import io.fabric8.kubernetes.api.builder.v3_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_1.Nested;
import io.fabric8.kubernetes.api.builder.v3_1.Predicate;
import io.fabric8.kubernetes.api.model.v3_1.ContainerStatus;
import io.fabric8.kubernetes.api.model.v3_1.ContainerStatusBuilder;
import io.fabric8.kubernetes.api.model.v3_1.ContainerStatusFluentImpl;
import io.fabric8.kubernetes.api.model.v3_1.PodCondition;
import io.fabric8.kubernetes.api.model.v3_1.PodConditionBuilder;
import io.fabric8.kubernetes.api.model.v3_1.PodConditionFluentImpl;
import io.fabric8.kubernetes.api.model.v3_1.PodStatus;
import io.fabric8.kubernetes.api.model.v3_1.PodStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PodStatusFluentImpl<A extends PodStatusFluent<A>>
extends BaseFluent<A>
implements PodStatusFluent<A> {
    private List<PodConditionBuilder> conditions = new ArrayList<PodConditionBuilder>();
    private List<ContainerStatusBuilder> containerStatuses = new ArrayList<ContainerStatusBuilder>();
    private String hostIP;
    private List<ContainerStatusBuilder> initContainerStatuses = new ArrayList<ContainerStatusBuilder>();
    private String message;
    private String phase;
    private String podIP;
    private String qosClass;
    private String reason;
    private String startTime;

    public PodStatusFluentImpl() {
    }

    public PodStatusFluentImpl(PodStatus instance) {
        this.withConditions(instance.getConditions());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withHostIP(instance.getHostIP());
        this.withInitContainerStatuses(instance.getInitContainerStatuses());
        this.withMessage(instance.getMessage());
        this.withPhase(instance.getPhase());
        this.withPodIP(instance.getPodIP());
        this.withQosClass(instance.getQosClass());
        this.withReason(instance.getReason());
        this.withStartTime(instance.getStartTime());
    }

    @Override
    public A addToConditions(int index, PodCondition item) {
        PodConditionBuilder builder = new PodConditionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, PodCondition item) {
        PodConditionBuilder builder = new PodConditionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(PodCondition ... items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<PodCondition> items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(PodCondition ... items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<PodCondition> items) {
        for (PodCondition item : items) {
            PodConditionBuilder builder = new PodConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<PodCondition> getConditions() {
        return PodStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<PodCondition> buildConditions() {
        return PodStatusFluentImpl.build(this.conditions);
    }

    @Override
    public PodCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public PodCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public PodCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public PodCondition buildMatchingCondition(Predicate<PodConditionBuilder> predicate) {
        for (PodConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConditions(List<PodCondition> conditions) {
        this._visitables.removeAll(this.conditions);
        this.conditions.clear();
        if (conditions != null) {
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(PodCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> addNewConditionLike(PodCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> setNewConditionLike(int index, PodCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public PodStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<PodConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addToContainerStatuses(int index, ContainerStatus item) {
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.containerStatuses.add(index >= 0 ? index : this.containerStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainerStatuses(int index, ContainerStatus item) {
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.containerStatuses.size()) {
            this.containerStatuses.add(builder);
        } else {
            this.containerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerStatuses(Collection<ContainerStatus> items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.remove(builder);
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerStatuses(Collection<ContainerStatus> items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.remove(builder);
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerStatus> getContainerStatuses() {
        return PodStatusFluentImpl.build(this.containerStatuses);
    }

    @Override
    public List<ContainerStatus> buildContainerStatuses() {
        return PodStatusFluentImpl.build(this.containerStatuses);
    }

    @Override
    public ContainerStatus buildContainerStatus(int index) {
        return this.containerStatuses.get(index).build();
    }

    @Override
    public ContainerStatus buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    @Override
    public ContainerStatus buildLastContainerStatus() {
        return this.containerStatuses.get(this.containerStatuses.size() - 1).build();
    }

    @Override
    public ContainerStatus buildMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withContainerStatuses(List<ContainerStatus> containerStatuses) {
        this._visitables.removeAll(this.containerStatuses);
        this.containerStatuses.clear();
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withContainerStatuses(ContainerStatus ... containerStatuses) {
        this.containerStatuses.clear();
        if (containerStatuses != null) {
            for (ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerStatuses() {
        return this.containerStatuses != null && !this.containerStatuses.isEmpty();
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNestedImpl();
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item) {
        return new ContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index, ContainerStatus item) {
        return new ContainerStatusesNestedImpl(index, item);
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index) {
        if (this.containerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
        if (this.containerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(0, this.buildContainerStatus(0));
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
        int index = this.containerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public PodStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerStatuses.size(); ++i) {
            if (!predicate.apply(this.containerStatuses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public String getHostIP() {
        return this.hostIP;
    }

    @Override
    public A withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (A)this;
    }

    @Override
    public Boolean hasHostIP() {
        return this.hostIP != null;
    }

    @Override
    public A addToInitContainerStatuses(int index, ContainerStatus item) {
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.initContainerStatuses.add(index >= 0 ? index : this.initContainerStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainerStatuses(int index, ContainerStatus item) {
        ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this.initContainerStatuses.add(builder);
        } else {
            this.initContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainerStatuses(Collection<ContainerStatus> items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainerStatuses(ContainerStatus ... items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.remove(builder);
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainerStatuses(Collection<ContainerStatus> items) {
        for (ContainerStatus item : items) {
            ContainerStatusBuilder builder = new ContainerStatusBuilder(item);
            this._visitables.remove(builder);
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ContainerStatus> getInitContainerStatuses() {
        return PodStatusFluentImpl.build(this.initContainerStatuses);
    }

    @Override
    public List<ContainerStatus> buildInitContainerStatuses() {
        return PodStatusFluentImpl.build(this.initContainerStatuses);
    }

    @Override
    public ContainerStatus buildInitContainerStatus(int index) {
        return this.initContainerStatuses.get(index).build();
    }

    @Override
    public ContainerStatus buildFirstInitContainerStatus() {
        return this.initContainerStatuses.get(0).build();
    }

    @Override
    public ContainerStatus buildLastInitContainerStatus() {
        return this.initContainerStatuses.get(this.initContainerStatuses.size() - 1).build();
    }

    @Override
    public ContainerStatus buildMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        for (ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withInitContainerStatuses(List<ContainerStatus> initContainerStatuses) {
        this._visitables.removeAll(this.initContainerStatuses);
        this.initContainerStatuses.clear();
        if (initContainerStatuses != null) {
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withInitContainerStatuses(ContainerStatus ... initContainerStatuses) {
        this.initContainerStatuses.clear();
        if (initContainerStatuses != null) {
            for (ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainerStatuses() {
        return this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty();
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus() {
        return new InitContainerStatusesNestedImpl();
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(ContainerStatus item) {
        return new InitContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index, ContainerStatus item) {
        return new InitContainerStatusesNestedImpl(index, item);
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(int index) {
        if (this.initContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus() {
        if (this.initContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(0, this.buildInitContainerStatus(0));
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus() {
        int index = this.initContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public PodStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainerStatuses.size(); ++i) {
            if (!predicate.apply(this.initContainerStatuses.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    public String getPodIP() {
        return this.podIP;
    }

    @Override
    public A withPodIP(String podIP) {
        this.podIP = podIP;
        return (A)this;
    }

    @Override
    public Boolean hasPodIP() {
        return this.podIP != null;
    }

    @Override
    public String getQosClass() {
        return this.qosClass;
    }

    @Override
    public A withQosClass(String qosClass) {
        this.qosClass = qosClass;
        return (A)this;
    }

    @Override
    public Boolean hasQosClass() {
        return this.qosClass != null;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodStatusFluentImpl that = (PodStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.containerStatuses != null ? !this.containerStatuses.equals(that.containerStatuses) : that.containerStatuses != null) {
            return false;
        }
        if (this.hostIP != null ? !this.hostIP.equals(that.hostIP) : that.hostIP != null) {
            return false;
        }
        if (this.initContainerStatuses != null ? !this.initContainerStatuses.equals(that.initContainerStatuses) : that.initContainerStatuses != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.podIP != null ? !this.podIP.equals(that.podIP) : that.podIP != null) {
            return false;
        }
        if (this.qosClass != null ? !this.qosClass.equals(that.qosClass) : that.qosClass != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        return !(this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null);
    }

    public class InitContainerStatusesNestedImpl<N>
    extends ContainerStatusFluentImpl<PodStatusFluent.InitContainerStatusesNested<N>>
    implements PodStatusFluent.InitContainerStatusesNested<N>,
    Nested<N> {
        private final ContainerStatusBuilder builder;
        private final int index;

        InitContainerStatusesNestedImpl(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        InitContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.setToInitContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endInitContainerStatus() {
            return this.and();
        }
    }

    public class ContainerStatusesNestedImpl<N>
    extends ContainerStatusFluentImpl<PodStatusFluent.ContainerStatusesNested<N>>
    implements PodStatusFluent.ContainerStatusesNested<N>,
    Nested<N> {
        private final ContainerStatusBuilder builder;
        private final int index;

        ContainerStatusesNestedImpl(int index, ContainerStatus item) {
            this.index = index;
            this.builder = new ContainerStatusBuilder(this, item);
        }

        ContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.setToContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endContainerStatus() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends PodConditionFluentImpl<PodStatusFluent.ConditionsNested<N>>
    implements PodStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final PodConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, PodCondition item) {
            this.index = index;
            this.builder = new PodConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new PodConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

