/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v3_1;

import io.fabric8.kubernetes.api.model.v3_1.RootPaths;
import io.fabric8.kubernetes.clnt.v3_1.Client;
import io.fabric8.kubernetes.clnt.v3_1.Config;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClientException;
import io.fabric8.openshift.clnt.v3_1.OpenShiftConfig;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class OpenshiftAdapterSupport {
    static final ConcurrentMap<URL, Boolean> IS_OPENSHIFT = new ConcurrentHashMap<URL, Boolean>();
    static final ConcurrentMap<URL, Boolean> USES_OPENSHIFT_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();

    public Boolean isAdaptable(Client client) {
        OpenShiftConfig config = new OpenShiftConfig((Config)client.getConfiguration());
        if (!OpenshiftAdapterSupport.hasCustomOpenShiftUrl(config) && !OpenshiftAdapterSupport.isOpenShift(client)) {
            return false;
        }
        return true;
    }

    static boolean isOpenShift(Client client) {
        List<String> paths;
        URL masterUrl = client.getMasterUrl();
        if (IS_OPENSHIFT.containsKey(masterUrl)) {
            return (Boolean)IS_OPENSHIFT.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.endsWith(".openshift.io") && !path.contains(".openshift.io/")) continue;
                USES_OPENSHIFT_APIGROUPS.putIfAbsent(masterUrl, true);
                IS_OPENSHIFT.putIfAbsent(masterUrl, true);
                return true;
            }
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path)) continue;
                IS_OPENSHIFT.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        IS_OPENSHIFT.putIfAbsent(masterUrl, false);
        return false;
    }

    static boolean isOpenShiftAPIGroups(Client client) {
        OpenShiftConfig openShiftConfig;
        Object configuration = client.getConfiguration();
        if (configuration instanceof OpenShiftConfig && (openShiftConfig = (OpenShiftConfig)configuration).isDisableApiGroupCheck()) {
            return false;
        }
        URL masterUrl = client.getMasterUrl();
        if (OpenshiftAdapterSupport.isOpenShift(client) && USES_OPENSHIFT_APIGROUPS.containsKey(masterUrl)) {
            return (Boolean)USES_OPENSHIFT_APIGROUPS.get(masterUrl);
        }
        return false;
    }

    static boolean hasCustomOpenShiftUrl(OpenShiftConfig config) {
        try {
            URI masterUri = new URI(config.getMasterUrl()).resolve("/");
            URI openshfitUri = new URI(config.getOpenShiftUrl()).resolve("/");
            return !masterUri.equals(openshfitUri);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

