/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v3_1;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.v3_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v3_1.ObjectMeta;
import io.fabric8.kubernetes.api.model.v3_1.validators.CheckObjectMeta;
import io.fabric8.openshift.api.model.v3_1.BuildConfigSpec;
import io.fabric8.openshift.api.model.v3_1.BuildConfigStatus;
import java.util.HashMap;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec", "status"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class BuildConfig
implements HasMetadata {
    @NotNull
    @JsonProperty(value="apiVersion")
    private String apiVersion = "build.openshift.io/v1";
    @NotNull
    @JsonProperty(value="kind")
    private String kind = "BuildConfig";
    @JsonProperty(value="metadata")
    @Valid
    @CheckObjectMeta(regexp="^[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*$", max=253)
    private ObjectMeta metadata;
    @JsonProperty(value="spec")
    @Valid
    private BuildConfigSpec spec;
    @JsonProperty(value="status")
    @Valid
    private BuildConfigStatus status;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public BuildConfig() {
    }

    public BuildConfig(String apiVersion, String kind, ObjectMeta metadata, BuildConfigSpec spec, BuildConfigStatus status) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.metadata = metadata;
        this.spec = spec;
        this.status = status;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        return this.kind;
    }

    @JsonProperty(value="kind")
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="metadata")
    public void setMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="spec")
    public BuildConfigSpec getSpec() {
        return this.spec;
    }

    @JsonProperty(value="spec")
    public void setSpec(BuildConfigSpec spec) {
        this.spec = spec;
    }

    @JsonProperty(value="status")
    public BuildConfigStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    public void setStatus(BuildConfigStatus status) {
        this.status = status;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        return "BuildConfig(apiVersion=" + this.getApiVersion() + ", kind=" + this.getKind() + ", metadata=" + this.getMetadata() + ", spec=" + this.getSpec() + ", status=" + this.getStatus() + ", additionalProperties=" + this.getAdditionalProperties() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildConfig)) {
            return false;
        }
        BuildConfig other = (BuildConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$apiVersion = this.getApiVersion();
        String other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) {
            return false;
        }
        String this$kind = this.getKind();
        String other$kind = other.getKind();
        if (this$kind == null ? other$kind != null : !this$kind.equals(other$kind)) {
            return false;
        }
        ObjectMeta this$metadata = this.getMetadata();
        ObjectMeta other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        BuildConfigSpec this$spec = this.getSpec();
        BuildConfigSpec other$spec = other.getSpec();
        if (this$spec == null ? other$spec != null : !((Object)this$spec).equals(other$spec)) {
            return false;
        }
        BuildConfigStatus this$status = this.getStatus();
        BuildConfigStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BuildConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $apiVersion = this.getApiVersion();
        result = result * 59 + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        String $kind = this.getKind();
        result = result * 59 + ($kind == null ? 43 : $kind.hashCode());
        ObjectMeta $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        BuildConfigSpec $spec = this.getSpec();
        result = result * 59 + ($spec == null ? 43 : ((Object)$spec).hashCode());
        BuildConfigStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

