/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v3_1.dsl.internal;

import io.fabric8.kubernetes.api.model.v3_1.Container;
import io.fabric8.kubernetes.api.model.v3_1.ContainerBuilder;
import io.fabric8.kubernetes.api.model.v3_1.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.v3_1.extensions.DoneableReplicaSet;
import io.fabric8.kubernetes.api.model.v3_1.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.v3_1.extensions.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.v3_1.extensions.ReplicaSetFluent;
import io.fabric8.kubernetes.api.model.v3_1.extensions.ReplicaSetList;
import io.fabric8.kubernetes.api.model.v3_1.extensions.ReplicaSetSpecFluent;
import io.fabric8.kubernetes.clnt.v3_1.Config;
import io.fabric8.kubernetes.clnt.v3_1.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v3_1.Watch;
import io.fabric8.kubernetes.clnt.v3_1.Watcher;
import io.fabric8.kubernetes.clnt.v3_1.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v3_1.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v3_1.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v3_1.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v3_1.dsl.Watchable;
import io.fabric8.kubernetes.clnt.v3_1.dsl.internal.ReplicaSetRollingUpdater;
import io.fabric8.kubernetes.clnt.v3_1.dsl.internal.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v3_1.dsl.internal.RollingUpdater;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;

public class ReplicaSetOperationsImpl
extends RollableScalableResourceOperation<ReplicaSet, ReplicaSetList, DoneableReplicaSet, RollableScalableResource<ReplicaSet, DoneableReplicaSet>>
implements TimeoutImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> {
    public ReplicaSetOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(client, config, "v1beta1", namespace, null, true, null, null, false, -1L, new TreeMap<String, String>(), new TreeMap<String, String>(), new TreeMap<String, String[]>(), new TreeMap<String, String[]>(), new TreeMap<String, String>(), false, config.getRollingTimeout(), TimeUnit.MILLISECONDS);
    }

    public ReplicaSetOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, ReplicaSet item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields) {
        this(client, config, apiVersion, namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, false, config.getRollingTimeout(), TimeUnit.MILLISECONDS);
    }

    public ReplicaSetOperationsImpl(OkHttpClient client, Config config, String apiVersion, String namespace, String name, Boolean cascading, ReplicaSet item, String resourceVersion, Boolean reloadingFromServer, long gracePeriodSeconds, Map<String, String> labels, Map<String, String> labelsNot, Map<String, String[]> labelsIn, Map<String, String[]> labelsNotIn, Map<String, String> fields, Boolean rolling, long rollingTimeout, TimeUnit rollingTimeUnit) {
        super(client, config, "extensions", apiVersion, "replicasets", namespace, name, cascading, item, resourceVersion, reloadingFromServer, gracePeriodSeconds, labels, labelsNot, labelsIn, labelsNotIn, fields, rolling, rollingTimeout, rollingTimeUnit);
    }

    @Override
    public ImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> withTimeout(long timeout, TimeUnit unit) {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (ReplicaSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, timeout, unit);
    }

    @Override
    public ImageEditReplacePatchable<ReplicaSet, ReplicaSet, DoneableReplicaSet> withTimeoutInMillis(long timeoutInMillis) {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.namespace, this.getName(), this.isCascading(), (ReplicaSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public RollableScalableResource<ReplicaSet, DoneableReplicaSet> withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), name, this.isCascading(), (ReplicaSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public RollableScalableResource<ReplicaSet, DoneableReplicaSet> fromServer() {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicaSet)this.getItem(), this.getResourceVersion(), true, this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public Watchable<Watch, Watcher<ReplicaSet>> withResourceVersion(String resourceVersion) {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicaSet)this.getItem(), resourceVersion, this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public EditReplacePatchDeletable<ReplicaSet, ReplicaSet, DoneableReplicaSet, Boolean> cascading(boolean enabled) {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), enabled, (ReplicaSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), this.rolling, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ReplicaSetOperationsImpl rolling() {
        return new ReplicaSetOperationsImpl(this.client, this.getConfig(), this.getAPIVersion(), this.getNamespace(), this.getName(), this.isCascading(), (ReplicaSet)this.getItem(), this.getResourceVersion(), this.isReloadingFromServer(), this.getGracePeriodSeconds(), this.getLabels(), this.getLabelsNot(), this.getLabelsIn(), this.getLabelsNotIn(), this.getFields(), true, this.rollingTimeout, this.rollingTimeUnit);
    }

    @Override
    public ReplicaSet updateImage(String image) {
        ReplicaSet oldRC = (ReplicaSet)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("Image update is not supported for multicontainer pods");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() == 0) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container updatedContainer = ((ContainerBuilder)new ContainerBuilder(oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next()).withImage(image)).build();
        ReplicaSetBuilder newRCBuilder = new ReplicaSetBuilder(oldRC);
        ((ReplicaSetFluent.SpecNested)((ReplicaSetSpecFluent.TemplateNested)((PodTemplateSpecFluent.SpecNested)((ReplicaSetBuilder)((ReplicaSetFluent.MetadataNested)newRCBuilder.editMetadata().withResourceVersion(null)).endMetadata()).editSpec().editTemplate().editSpec().withContainers(Collections.singletonList(updatedContainer))).endSpec()).endTemplate()).endSpec();
        return new ReplicaSetRollingUpdater(this.client, this.config, this.namespace).rollUpdate(oldRC, newRCBuilder.build());
    }

    @Override
    public ReplicaSet waitUntilReady(long amount, TimeUnit timeUnit) throws InterruptedException {
        ReplicaSet rs = (ReplicaSet)this.get();
        if (rs == null) {
            throw new IllegalArgumentException("ReplicaSet with name:[" + this.name + "] in namespace:[" + this.namespace + "] not found!");
        }
        return (ReplicaSet)this.periodicWatchUntilReady(10, System.currentTimeMillis(), Math.max(timeUnit.toMillis(amount) / 10L, 1000L), amount);
    }

    @Override
    ReplicaSet withReplicas(int count) {
        return ((DoneableReplicaSet)((ReplicaSetFluent.SpecNested)((DoneableReplicaSet)this.cascading(false).edit()).editSpec().withReplicas(count)).endSpec()).done();
    }

    @Override
    RollingUpdater<ReplicaSet, ReplicaSetList, DoneableReplicaSet> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicaSetRollingUpdater(this.client, this.config, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    int getCurrentReplicas(ReplicaSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    int getDesiredReplicas(ReplicaSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    long getObservedGeneration(ReplicaSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }
}

