/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v3_1;

import io.fabric8.kubernetes.api.builder.v3_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v3_1.Nested;
import io.fabric8.kubernetes.api.model.v3_1.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v3_1.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v3_1.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v3_1.SecretSpec;
import io.fabric8.openshift.api.model.v3_1.SecretSpecFluent;

public class SecretSpecFluentImpl<A extends SecretSpecFluent<A>>
extends BaseFluent<A>
implements SecretSpecFluent<A> {
    private String mountPath;
    private LocalObjectReferenceBuilder secretSource;

    public SecretSpecFluentImpl() {
    }

    public SecretSpecFluentImpl(SecretSpec instance) {
        this.withMountPath(instance.getMountPath());
        this.withSecretSource(instance.getSecretSource());
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)this;
    }

    @Override
    public Boolean hasMountPath() {
        return this.mountPath != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getSecretSource() {
        return this.secretSource != null ? this.secretSource.build() : null;
    }

    @Override
    public LocalObjectReference buildSecretSource() {
        return this.secretSource != null ? this.secretSource.build() : null;
    }

    @Override
    public A withSecretSource(LocalObjectReference secretSource) {
        this._visitables.remove(this.secretSource);
        if (secretSource != null) {
            this.secretSource = new LocalObjectReferenceBuilder(secretSource);
            this._visitables.add(this.secretSource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretSource() {
        return this.secretSource != null;
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> withNewSecretSource() {
        return new SecretSourceNestedImpl();
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> withNewSecretSourceLike(LocalObjectReference item) {
        return new SecretSourceNestedImpl(item);
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> editSecretSource() {
        return this.withNewSecretSourceLike(this.getSecretSource());
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> editOrNewSecretSource() {
        return this.withNewSecretSourceLike(this.getSecretSource() != null ? this.getSecretSource() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public SecretSpecFluent.SecretSourceNested<A> editOrNewSecretSourceLike(LocalObjectReference item) {
        return this.withNewSecretSourceLike(this.getSecretSource() != null ? this.getSecretSource() : item);
    }

    @Override
    public A withNewSecretSource(String name) {
        return this.withSecretSource(new LocalObjectReference(name));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecretSpecFluentImpl that = (SecretSpecFluentImpl)o;
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        return !(this.secretSource != null ? !this.secretSource.equals(that.secretSource) : that.secretSource != null);
    }

    public class SecretSourceNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<SecretSpecFluent.SecretSourceNested<N>>
    implements SecretSpecFluent.SecretSourceNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SecretSourceNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SecretSourceNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecretSpecFluentImpl.this.withSecretSource(this.builder.build());
        }

        @Override
        public N endSecretSource() {
            return this.and();
        }
    }
}

