/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v3_1.utils;

import io.fabric8.kubernetes.clnt.v3_1.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v3_1.Watcher;
import java.util.Objects;

public class WatcherToggle<T>
implements Watcher<T> {
    private Watcher<T> delegate;
    private boolean enabled;

    public WatcherToggle(Watcher<T> delegate, boolean enabled) {
        this.delegate = Objects.requireNonNull(delegate, "delegate watcher cannot be null");
        this.enabled = enabled;
    }

    public void disable() {
        this.enabled = false;
    }

    public void enable() {
        this.enabled = true;
    }

    @Override
    public void eventReceived(Watcher.Action action, T resource) {
        if (this.enabled) {
            this.delegate.eventReceived(action, resource);
        }
    }

    @Override
    public void onClose(KubernetesClientException cause) {
        if (this.enabled) {
            this.delegate.onClose(cause);
        }
    }
}

