/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v3_1.server.mock;

import io.fabric8.kubernetes.api.model.v3_1.HasMetadata;
import io.fabric8.kubernetes.clnt.v3_1.utils.Serialization;
import io.fabric8.mockwebserver.crud.Attribute;
import io.fabric8.mockwebserver.crud.AttributeExtractor;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.zjsonpatch.internal.guava.Strings;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesAttributesExtractor
implements AttributeExtractor<HasMetadata> {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesAttributesExtractor.class);
    public static final String KIND = "kind";
    public static final String NAME = "name";
    public static final String NAMESPACE = "namespace";
    private static final String API_GROUP = "/api[s]?(/extensions)?";
    private static final String VERSION_GROUP = "(/(?<version>[a-zA-z0-9-_]+))?";
    private static final String KIND_GROUP = "/(?<kind>[^/?]+)";
    private static final String NAME_GROUP = "(/(?<name>[^/?]+))?";
    private static final String NAMESPACE_GROUP = "(/namespaces/(?<namespace>[^/]+))?";
    private static final String END_GROUP = "[^ /]*";
    protected static final Pattern PATTERN = Pattern.compile("/api[s]?(/extensions)?(/(?<version>[a-zA-z0-9-_]+))?(/namespaces/(?<namespace>[^/]+))?/(?<kind>[^/?]+)(/(?<name>[^/?]+))?[^ /]*");

    public AttributeSet fromPath(String s) {
        if (s == null || s.isEmpty()) {
            return new AttributeSet(new Attribute[0]);
        }
        Matcher m = PATTERN.matcher(s);
        if (m.matches()) {
            AttributeSet set = KubernetesAttributesExtractor.extract(m);
            LOGGER.debug("fromPath {} : {}", (Object)s, (Object)set);
            return set;
        }
        return new AttributeSet(new Attribute[0]);
    }

    public AttributeSet fromResource(String s) {
        if (s == null || s.isEmpty()) {
            return new AttributeSet(new Attribute[0]);
        }
        HasMetadata h = KubernetesAttributesExtractor.toKubernetesResource(s);
        if (h != null) {
            return this.extract(h);
        }
        return new AttributeSet(new Attribute[0]);
    }

    public AttributeSet extract(String s) {
        if (s == null || s.isEmpty()) {
            return new AttributeSet(new Attribute[0]);
        }
        HasMetadata h = KubernetesAttributesExtractor.toKubernetesResource(s);
        if (h != null) {
            return this.extract(h);
        }
        Matcher m = PATTERN.matcher(s);
        if (m.matches()) {
            AttributeSet set = KubernetesAttributesExtractor.extract(m);
            LOGGER.debug("extract {} : {}", (Object)s, (Object)set);
            return set;
        }
        LOGGER.debug("extract {} : no attributes", (Object)s);
        return new AttributeSet(new Attribute[0]);
    }

    public AttributeSet extract(HasMetadata o) {
        AttributeSet attributes = new AttributeSet(new Attribute[0]);
        if (!Strings.isNullOrEmpty((String)o.getKind())) {
            attributes = attributes.add(new Attribute[]{new Attribute(KIND, o.getKind().toLowerCase())});
        }
        if (!Strings.isNullOrEmpty((String)o.getMetadata().getName())) {
            attributes = attributes.add(new Attribute[]{new Attribute(NAME, o.getMetadata().getName())});
        }
        if (!Strings.isNullOrEmpty((String)o.getMetadata().getNamespace())) {
            attributes = attributes.add(new Attribute[]{new Attribute(NAMESPACE, o.getMetadata().getNamespace())});
        }
        return attributes;
    }

    private static AttributeSet extract(Matcher m) {
        AttributeSet attributes = new AttributeSet(new Attribute[0]);
        if (m.matches()) {
            String namespace;
            String kind = m.group(KIND);
            if (!Strings.isNullOrEmpty((String)kind)) {
                if (kind.endsWith("ses")) {
                    kind = kind.substring(0, kind.length() - 2);
                } else if (kind.equalsIgnoreCase("PodSecurityPolicies") || kind.equalsIgnoreCase("NetworkPolicies")) {
                    kind = kind.substring(0, kind.length() - 3) + "y";
                } else if (!kind.equalsIgnoreCase("securityContextConstraints") && kind.endsWith("s")) {
                    kind = kind.substring(0, kind.length() - 1);
                }
                attributes = attributes.add(new Attribute[]{new Attribute(KIND, kind)});
            }
            if (!Strings.isNullOrEmpty((String)(namespace = m.group(NAMESPACE)))) {
                attributes = attributes.add(new Attribute[]{new Attribute(NAMESPACE, namespace)});
            }
            try {
                String name = m.group(NAME);
                if (!Strings.isNullOrEmpty((String)name)) {
                    attributes = attributes.add(new Attribute[]{new Attribute(NAME, name)});
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return attributes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HasMetadata toKubernetesResource(String s) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8.name()));){
            HasMetadata hasMetadata = (HasMetadata)Serialization.unmarshal(stream);
            return hasMetadata;
        }
        catch (Exception e) {
            return null;
        }
    }
}

